/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.runtime.impl.plugin;

import com.buschmais.jqassistant.core.analysis.api.RuleInterpreterPlugin;
import com.buschmais.jqassistant.core.analysis.spi.AnalyzerPluginRepository;
import com.buschmais.jqassistant.core.report.api.ReportContext;
import com.buschmais.jqassistant.core.report.api.ReportException;
import com.buschmais.jqassistant.core.report.api.ReportPlugin;
import com.buschmais.jqassistant.core.report.api.configuration.Report;
import com.buschmais.jqassistant.core.runtime.api.plugin.PluginConfigurationReader;
import com.buschmais.jqassistant.core.runtime.api.plugin.PluginRepositoryException;
import com.buschmais.jqassistant.core.runtime.impl.plugin.AbstractPluginRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jqassistant.schema.plugin.v2.IdClassListType;
import org.jqassistant.schema.plugin.v2.IdClassType;
import org.jqassistant.schema.plugin.v2.JqassistantPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzerPluginRepositoryImpl
extends AbstractPluginRepository
implements AnalyzerPluginRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyzerPluginRepositoryImpl.class);
    private final Map<String, ReportPlugin> reportPlugins = new HashMap<String, ReportPlugin>();
    private final Map<String, Collection<RuleInterpreterPlugin>> ruleInterpreterPlugins = new HashMap<String, Collection<RuleInterpreterPlugin>>();

    public AnalyzerPluginRepositoryImpl(PluginConfigurationReader pluginConfigurationReader) {
        super(pluginConfigurationReader);
    }

    public Map<String, ReportPlugin> getReportPlugins(Report configuration, ReportContext reportContext) {
        Map properties = Collections.unmodifiableMap(configuration.properties());
        for (ReportPlugin reportPlugin : this.reportPlugins.values()) {
            try {
                reportPlugin.configure(reportContext, properties);
            }
            catch (ReportException e) {
                throw new PluginRepositoryException("Cannot configure report plugin " + reportPlugin, e);
            }
        }
        return this.reportPlugins;
    }

    public Map<String, Collection<RuleInterpreterPlugin>> getRuleInterpreterPlugins(Map<String, Object> properties) {
        for (Collection<RuleInterpreterPlugin> languagePlugins : this.ruleInterpreterPlugins.values()) {
            for (RuleInterpreterPlugin ruleInterpreterPlugin : languagePlugins) {
                ruleInterpreterPlugin.configure(properties);
            }
        }
        return this.ruleInterpreterPlugins;
    }

    public void initialize() {
        for (JqassistantPlugin plugin : this.plugins) {
            IdClassListType reportTypes = plugin.getReport();
            this.initializeReportPlugins(reportTypes);
            this.initializeRuleInterpreterPlugins(plugin);
        }
    }

    private void initializeReportPlugins(IdClassListType reportTypes) {
        if (reportTypes != null) {
            for (IdClassType classType : reportTypes.getClazz()) {
                ReportPlugin reportPlugin = (ReportPlugin)this.createInstance(classType.getValue());
                if (reportPlugin == null) continue;
                try {
                    reportPlugin.initialize();
                }
                catch (ReportException e) {
                    throw new PluginRepositoryException("Cannot initialize report plugin " + reportPlugin, e);
                }
                String id = classType.getId();
                if (id == null) {
                    id = reportPlugin.getClass().getSimpleName();
                }
                this.reportPlugins.put(id, reportPlugin);
            }
        }
    }

    private void initializeRuleInterpreterPlugins(JqassistantPlugin plugin) {
        IdClassListType ruleInterpreters = plugin.getRuleInterpreter();
        if (ruleInterpreters != null) {
            for (IdClassType pluginType : ruleInterpreters.getClazz()) {
                RuleInterpreterPlugin ruleInterpreterPlugin = (RuleInterpreterPlugin)this.createInstance(pluginType.getValue());
                ruleInterpreterPlugin.initialize();
                for (String language : ruleInterpreterPlugin.getLanguages()) {
                    Collection<RuleInterpreterPlugin> plugins = this.ruleInterpreterPlugins.get(language.toLowerCase());
                    if (plugins == null) {
                        plugins = new ArrayList<RuleInterpreterPlugin>();
                        this.ruleInterpreterPlugins.put(language.toLowerCase(), plugins);
                    }
                    plugins.add(ruleInterpreterPlugin);
                }
            }
        }
    }

    public void destroy() {
        this.reportPlugins.values().forEach(plugin -> {
            try {
                plugin.destroy();
            }
            catch (ReportException e) {
                LOGGER.warn("Cannot destroy plugin {}", plugin, (Object)e);
            }
        });
        this.ruleInterpreterPlugins.values().stream().flatMap(plugins -> plugins.stream()).forEach(plugin -> plugin.destroy());
    }
}

