/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.runtime.impl.plugin;

import com.buschmais.jqassistant.core.runtime.api.plugin.PluginConfigurationReader;
import com.buschmais.jqassistant.core.runtime.impl.plugin.AbstractPluginRepository;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.scanner.api.configuration.Scan;
import com.buschmais.jqassistant.core.scanner.spi.ScannerPluginRepository;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jqassistant.schema.plugin.v2.ClassListType;
import org.jqassistant.schema.plugin.v2.IdClassListType;
import org.jqassistant.schema.plugin.v2.IdClassType;
import org.jqassistant.schema.plugin.v2.JqassistantPlugin;

public class ScannerPluginRepositoryImpl
extends AbstractPluginRepository
implements ScannerPluginRepository {
    private Map<String, ScannerPlugin<?, ?>> scannerPlugins = new HashMap();
    private Map<String, Scope> scopes = Collections.unmodifiableMap(this.getScopes(this.plugins));

    public ScannerPluginRepositoryImpl(PluginConfigurationReader pluginConfigurationReader) {
        super(pluginConfigurationReader);
    }

    public void initialize() {
        this.getScannerPlugins(this.plugins);
    }

    public void destroy() {
        this.scannerPlugins.values().forEach(scannerPlugin -> scannerPlugin.destroy());
    }

    public Map<String, ScannerPlugin<?, ?>> getScannerPlugins(Scan scan, ScannerContext scannerContext) {
        Map properties = Collections.unmodifiableMap(scan.properties());
        for (ScannerPlugin<?, ?> scannerPlugin : this.scannerPlugins.values()) {
            scannerPlugin.configure(scannerContext, properties);
        }
        return this.scannerPlugins;
    }

    public Scope getScope(String name) {
        return this.scopes.get(name.toLowerCase());
    }

    public Map<String, Scope> getScopes() {
        return this.scopes;
    }

    private void getScannerPlugins(List<JqassistantPlugin> plugins) {
        for (JqassistantPlugin plugin : plugins) {
            IdClassListType scannerTypes = plugin.getScanner();
            if (scannerTypes == null) continue;
            for (IdClassType classType : scannerTypes.getClazz()) {
                ScannerPlugin scannerPlugin = (ScannerPlugin)this.createInstance(classType.getValue());
                if (scannerPlugin == null) continue;
                scannerPlugin.initialize();
                String id = classType.getId();
                if (id == null) {
                    id = scannerPlugin.getClass().getSimpleName();
                }
                this.scannerPlugins.put(id, scannerPlugin);
            }
        }
    }

    private Map<String, Scope> getScopes(List<JqassistantPlugin> plugins) {
        HashMap<String, Scope> scopes = new HashMap<String, Scope>();
        for (JqassistantPlugin plugin : plugins) {
            ClassListType scopeTypes = plugin.getScope();
            if (scopeTypes == null) continue;
            for (String scopePluginName : scopeTypes.getClazz()) {
                Class type = this.getType(scopePluginName);
                for (Enum enumConstant : (Enum[])type.getEnumConstants()) {
                    Scope scope = (Scope)enumConstant;
                    String scopeName = scope.getPrefix() + ":" + scope.getName();
                    scopes.put(scopeName.toLowerCase(), scope);
                }
            }
        }
        return scopes;
    }
}

