/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.runtime.api.configuration;

import com.buschmais.jqassistant.core.runtime.api.configuration.Configuration;
import com.buschmais.jqassistant.core.runtime.api.configuration.ConfigurationSerializer;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.ExpressionConfigSourceInterceptor;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.source.yaml.YamlConfigSource;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationMappingLoader {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationMappingLoader.class);
    public static final List<String> DEFAULT_CONFIG_LOCATIONS = Arrays.asList(".jqassistant.yml", ".jqassistant.yaml", ".jqassistant");
    public static final int ORDINAL_USERHOME = 50;
    public static final int ORDINAL_CLASSPATH = 80;
    public static final int ORDINAL_WORKING_DIRECTORY = 150;
    private static final String YAML = ".yaml";
    private static final String YML = ".yml";
    private static final String CLASSPATH_RESOURCE = ".jqassistant.yml";

    public static <C extends Configuration> Builder<C> builder(Class<C> configurationMapping) {
        return new Builder<C>(configurationMapping, Collections.emptyList());
    }

    public static <C extends Configuration> Builder<C> builder(Class<C> configurationMapping, List<String> configLocations) {
        return new Builder<C>(configurationMapping, configLocations);
    }

    public static class Builder<C extends Configuration> {
        private final ConfigurationSerializer<C> configurationSerializer = new ConfigurationSerializer();
        private final Class<C> configurationMapping;
        private final List<String> configLocations;
        private final List<ConfigSource> configSources = new ArrayList<ConfigSource>();
        private final List<String> profiles = new ArrayList<String>();

        private Builder(Class<C> configurationMapping, List<String> configLocations) {
            this.configurationMapping = configurationMapping;
            this.configLocations = configLocations;
        }

        public Builder<C> withUserHome(File userHome) {
            this.configSources.addAll(Builder.getExternalYamlConfigSources(userHome, DEFAULT_CONFIG_LOCATIONS, 50));
            return this;
        }

        public Builder<C> withWorkingDirectory(File workingDirectory) {
            return this.withDirectory(workingDirectory, 150);
        }

        public Builder<C> withDirectory(File directory, int ordinal) {
            this.configSources.addAll(Builder.getExternalYamlConfigSources(directory, this.configLocations.isEmpty() ? DEFAULT_CONFIG_LOCATIONS : this.configLocations, ordinal));
            return this;
        }

        public Builder<C> withClasspath() {
            this.configSources.addAll(Builder.getYamlConfigSourceFromClasspath());
            return this;
        }

        public Builder<C> withEnvVariables() {
            this.configSources.add((ConfigSource)new EnvConfigSource(){});
            return this;
        }

        public Builder<C> withProfiles(List<String> profiles) {
            this.profiles.addAll(profiles);
            return this;
        }

        public C load(ConfigSource ... additionalConfigSources) {
            SmallRyeConfig config = new SmallRyeConfigBuilder().withMapping(this.configurationMapping).withSources(this.configSources).withSources(additionalConfigSources).withValidateUnknown(false).withInterceptors(new ConfigSourceInterceptor[]{new ExpressionConfigSourceInterceptor()}).withProfiles(this.profiles).build();
            Configuration configMapping = (Configuration)config.getConfigMapping(this.configurationMapping);
            if (log.isDebugEnabled()) {
                log.info("Loaded configuration from {} config sources:\n{}", (Object)additionalConfigSources.length, (Object)this.configurationSerializer.toYaml(configMapping));
            }
            return (C)configMapping;
        }

        private static List<ConfigSource> getExternalYamlConfigSources(File directory, List<String> configLocations, int ordinal) {
            ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
            for (String configLocation : configLocations) {
                File file = directory.toPath().resolve(Paths.get(configLocation, new String[0])).toFile();
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    configSources.addAll(Builder.getYamlConfigSources(file, ordinal));
                    continue;
                }
                configSources.add((ConfigSource)Builder.getYamlConfigSource(file.toPath(), ordinal));
            }
            return configSources;
        }

        private static List<ConfigSource> getYamlConfigSources(File configurationDirectory, int ordinal) {
            log.info("Loading configuration from directory '{}'.", (Object)configurationDirectory.getAbsolutePath());
            List<Path> configurationFiles = Builder.getYamlConfigurationFiles(configurationDirectory);
            return configurationFiles.stream().map(path -> Builder.getYamlConfigSource(path, ordinal)).collect(Collectors.toList());
        }

        private static List<Path> getYamlConfigurationFiles(File configurationDirectory) {
            final ArrayList<Path> configurationFiles = new ArrayList<Path>();
            try {
                Files.walkFileTree(configurationDirectory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        String fileName = file.toFile().getName();
                        if (fileName.endsWith(ConfigurationMappingLoader.YAML) || fileName.endsWith(ConfigurationMappingLoader.YML)) {
                            configurationFiles.add(file);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot list files in configuration directory " + configurationDirectory, e);
            }
            return configurationFiles;
        }

        private static YamlConfigSource getYamlConfigSource(Path path, int ordinal) {
            log.info("Loading configuration from file '{}'.", (Object)path.toAbsolutePath());
            try {
                return Builder.getYamlConfigSource(path.toUri().toURL(), ordinal);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Cannot convert path '" + path + "' ot URL.");
            }
        }

        private static List<ConfigSource> getYamlConfigSourceFromClasspath() {
            try {
                Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(ConfigurationMappingLoader.CLASSPATH_RESOURCE);
                return Collections.list(resources).stream().map(resource -> Builder.getYamlConfigSource(resource, 80)).collect(Collectors.toUnmodifiableList());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot get classpath resources for .jqassistant.yml", e);
            }
        }

        private static YamlConfigSource getYamlConfigSource(URL url, int ordinal) {
            try {
                return new YamlConfigSource(url, ordinal);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot create YAML config source from URL " + url, e);
            }
        }
    }
}

