/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.runtime.api.configuration;

import com.buschmais.jqassistant.core.runtime.api.configuration.Configuration;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappingInterface;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.MethodProperty;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.Representer;

public class ConfigurationSerializer<C extends Configuration> {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationSerializer.class);

    public String toYaml(C configuration) {
        DumperOptions dumperOptions = ConfigurationSerializer.getDumperOptions();
        Representer representer = ConfigurationSerializer.getRepresenter(dumperOptions);
        Yaml yaml = new Yaml(representer);
        yaml.setBeanAccess(BeanAccess.PROPERTY);
        Optional<Class<?>> configInterface = ConfigurationSerializer.getConfigInterface(configuration.getClass());
        return configInterface.map(type -> {
            HashMap<String, Configuration> configRoot = new HashMap<String, Configuration>();
            configRoot.put(type.getAnnotation(ConfigMapping.class).prefix(), (Configuration)configuration);
            return yaml.dump(configRoot);
        }).orElseThrow(() -> new IllegalArgumentException("Cannot serialize object without ConfigMapping: " + configuration));
    }

    private static DumperOptions getDumperOptions() {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dumperOptions.setPrettyFlow(true);
        dumperOptions.setIndent(2);
        dumperOptions.setAllowReadOnlyProperties(true);
        return dumperOptions;
    }

    private static Representer getRepresenter(DumperOptions dumperOptions) {
        ConfigPropertyUtils propertyUtils = new ConfigPropertyUtils();
        propertyUtils.setAllowReadOnlyProperties(true);
        return new ConfigRepresenter(dumperOptions, propertyUtils);
    }

    private static Optional<Class<?>> getConfigInterface(Class<?> configType) {
        return Arrays.stream(configType.getInterfaces()).filter(i -> i.isAnnotationPresent(ConfigMapping.class)).findFirst();
    }

    private static List<Class<?>> getImplementedInterfaces(Class<?> type) {
        LinkedList result = new LinkedList();
        result.add(type);
        for (Class<?> anInterface : type.getInterfaces()) {
            result.addAll(ConfigurationSerializer.getImplementedInterfaces(anInterface));
        }
        return result;
    }

    private static class ConfigPropertyUtils
    extends PropertyUtils {
        private ConfigPropertyUtils() {
        }

        protected Map<String, Property> getPropertiesMap(Class<?> type, BeanAccess bAccess) {
            Optional<Class<?>> configInterface = ConfigurationSerializer.getConfigInterface(type);
            return configInterface.map(configurationInterface -> {
                HashMap<String, Property> properties = new HashMap<String, Property>();
                for (Class<?> implementedInterface : ConfigurationSerializer.getImplementedInterfaces(configurationInterface)) {
                    ConfigMappingInterface configMappingInterface = ConfigMappingInterface.getConfigurationInterface(implementedInterface);
                    ConfigMappingInterface.NamingStrategy namingStrategy = configMappingInterface.getNamingStrategy();
                    for (ConfigMappingInterface.Property property : configMappingInterface.getProperties()) {
                        String propertyName = (String)namingStrategy.apply((Object)property.getPropertyName());
                        properties.put(propertyName, this.getProperty(propertyName, property.getMethod()));
                    }
                }
                return properties;
            }).orElseGet(() -> {
                log.warn("Type '{}' does not implement an interface annotated by '{}'.", (Object)type.getName(), (Object)ConfigMapping.class.getName());
                return Collections.emptyMap();
            });
        }

        private Property getProperty(String propertyName, Method method) {
            try {
                return new MethodProperty(new PropertyDescriptor(propertyName, method, null));
            }
            catch (IntrospectionException e) {
                throw new IllegalStateException("Cannot create method property for " + propertyName + " from method " + method, e);
            }
        }
    }

    private static class ConfigRepresenter
    extends Representer {
        ConfigRepresenter(DumperOptions options, PropertyUtils propertyUtils) {
            super(options);
            super.setPropertyUtils(propertyUtils);
            this.setDefaultFlowStyle(options.getDefaultFlowStyle());
            this.representers.put(Optional.class, new RepresentOptional());
            RepresentString representString = new RepresentString();
            this.representers.put(URI.class, representString);
            this.representers.put(File.class, representString);
        }

        protected MappingNode representJavaBean(Set<Property> properties, Object javaBean) {
            this.addClassTag(javaBean.getClass(), Tag.MAP);
            return super.representJavaBean(properties, javaBean);
        }

        protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
            return ConfigRepresenter.isNullOrEmpty(propertyValue) ? null : super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
        }

        private static boolean isNullOrEmpty(Object propertyValue) {
            return propertyValue == null || propertyValue instanceof Optional && !((Optional)propertyValue).isPresent();
        }

        private class RepresentOptional
        implements Represent {
            private RepresentOptional() {
            }

            public Node representData(Object data) {
                return ConfigRepresenter.this.representData(((Optional)data).orElse(null));
            }
        }

        private class RepresentString
        implements Represent {
            private RepresentString() {
            }

            public Node representData(Object data) {
                return ConfigRepresenter.this.representData(data.toString());
            }
        }
    }
}

