/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.runtime.impl.plugin;

import com.buschmais.jqassistant.core.runtime.api.plugin.PluginRepositoryException;
import com.buschmais.jqassistant.core.shared.artifact.ArtifactProvider;
import com.buschmais.jqassistant.core.shared.configuration.Exclusion;
import com.buschmais.jqassistant.core.shared.configuration.Plugin;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.filter.DependencyFilterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AetherArtifactProvider
implements ArtifactProvider {
    private static final Logger log = LoggerFactory.getLogger(AetherArtifactProvider.class);
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession repositorySystemSession;
    private final List<RemoteRepository> repositories;

    public List<File> resolve(List<Plugin> plugins) {
        List<Dependency> requiredPlugins = this.getDependencies(plugins);
        DependencyResult dependencyResult = this.resolvePlugins(requiredPlugins);
        return this.asFiles(dependencyResult);
    }

    private List<Dependency> getDependencies(List<Plugin> plugins) {
        return plugins.stream().flatMap(plugin -> this.getPluginDependencies((Plugin)plugin).stream()).collect(Collectors.toList());
    }

    private DependencyResult resolvePlugins(List<Dependency> dependencies) {
        DependencyFilter classpathFilter = DependencyFilterUtils.classpathFilter((String[])new String[]{"runtime"});
        DependencyResult dependencyResult = this.resolveDependencies(classpathFilter, dependencies);
        if (log.isDebugEnabled()) {
            this.logDependencyTree(dependencyResult.getRoot(), 0);
        }
        return dependencyResult;
    }

    private List<Dependency> getPluginDependencies(Plugin plugin) {
        List exlusions = plugin.exclusions().stream().map(AetherArtifactProvider::getPluginExclusions).flatMap(Collection::stream).collect(Collectors.toList());
        return plugin.artifactId().stream().map(artifactId -> AetherArtifactProvider.getDependency(plugin, artifactId.trim(), exlusions)).collect(Collectors.toList());
    }

    private static Dependency getDependency(Plugin plugin, String artifactId, List<org.eclipse.aether.graph.Exclusion> exlusions) {
        return new Dependency((Artifact)new DefaultArtifact(plugin.groupId(), artifactId, (String)plugin.classifier().orElse(null), plugin.type(), plugin.version()), "runtime", Boolean.valueOf(false), exlusions);
    }

    private static List<org.eclipse.aether.graph.Exclusion> getPluginExclusions(Exclusion exclusion) {
        return exclusion.artifactId().stream().map(artifactId -> new org.eclipse.aether.graph.Exclusion(exclusion.groupId(), artifactId.trim(), (String)exclusion.classifier().orElse(null), exclusion.type())).collect(Collectors.toList());
    }

    private DependencyResult resolveDependencies(DependencyFilter classpathFilter, List<Dependency> dependencies) {
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setDependencies(dependencies);
        collectRequest.setRepositories(this.repositories);
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, classpathFilter);
        try {
            return this.repositorySystem.resolveDependencies(this.repositorySystemSession, dependencyRequest);
        }
        catch (DependencyResolutionException e) {
            throw new PluginRepositoryException("Cannot resolve plugin dependencies", e);
        }
    }

    private void logDependencyTree(DependencyNode node, int indent) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            builder.append(' ');
        }
        Artifact artifact = node.getArtifact();
        if (artifact != null) {
            log.info("{}{}", (Object)builder, (Object)artifact);
        }
        for (DependencyNode child : node.getChildren()) {
            this.logDependencyTree(child, indent + 2);
        }
    }

    private List<File> asFiles(DependencyResult dependencyResult) {
        return dependencyResult.getArtifactResults().stream().map(artifactResult -> artifactResult.getArtifact().getFile()).collect(Collectors.toList());
    }

    public RepositorySystem getRepositorySystem() {
        return this.repositorySystem;
    }

    public RepositorySystemSession getRepositorySystemSession() {
        return this.repositorySystemSession;
    }

    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    public AetherArtifactProvider(RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession, List<RemoteRepository> repositories) {
        this.repositorySystem = repositorySystem;
        this.repositorySystemSession = repositorySystemSession;
        this.repositories = repositories;
    }
}

