/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.runtime.impl.plugin;

import com.buschmais.jqassistant.core.rule.api.configuration.Rule;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.reader.RuleParserPlugin;
import com.buschmais.jqassistant.core.rule.api.source.ClasspathRuleSource;
import com.buschmais.jqassistant.core.rule.api.source.RuleSource;
import com.buschmais.jqassistant.core.rule.spi.RulePluginRepository;
import com.buschmais.jqassistant.core.runtime.api.plugin.PluginConfigurationReader;
import com.buschmais.jqassistant.core.runtime.api.plugin.PluginRepositoryException;
import com.buschmais.jqassistant.core.runtime.impl.plugin.AbstractPluginRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jqassistant.schema.plugin.v2.IdClassListType;
import org.jqassistant.schema.plugin.v2.IdClassType;
import org.jqassistant.schema.plugin.v2.JqassistantPlugin;
import org.jqassistant.schema.plugin.v2.RulesType;

public class RulePluginRepositoryImpl
extends AbstractPluginRepository
implements RulePluginRepository {
    private final ClassLoader classLoader;
    private final List<RuleSource> sources;
    private final Collection<RuleParserPlugin> ruleParserPlugins = new LinkedList<RuleParserPlugin>();

    public RulePluginRepositoryImpl(PluginConfigurationReader pluginConfigurationReader) {
        super(pluginConfigurationReader);
        this.classLoader = pluginConfigurationReader.getClassLoader();
        this.sources = this.getRuleSources(pluginConfigurationReader.getPlugins());
    }

    public List<RuleSource> getRuleSources() {
        return this.sources;
    }

    public Collection<RuleParserPlugin> getRuleParserPlugins(Rule rule) throws RuleException {
        for (RuleParserPlugin ruleParserPlugin : this.ruleParserPlugins) {
            ruleParserPlugin.configure(rule);
        }
        return this.ruleParserPlugins;
    }

    public void initialize() {
        for (JqassistantPlugin plugin : this.plugins) {
            IdClassListType ruleParsers = plugin.getRuleParser();
            if (ruleParsers == null) continue;
            for (IdClassType pluginType : ruleParsers.getClazz()) {
                RuleParserPlugin ruleParserPlugin = (RuleParserPlugin)this.createInstance(pluginType.getValue());
                try {
                    ruleParserPlugin.initialize();
                }
                catch (RuleException e) {
                    throw new PluginRepositoryException("Cannot initialize plugin " + ruleParserPlugin, e);
                }
                this.ruleParserPlugins.add(ruleParserPlugin);
            }
        }
    }

    public void destroy() {
        for (RuleParserPlugin ruleParserPlugin : this.ruleParserPlugins) {
            try {
                ruleParserPlugin.destroy();
            }
            catch (RuleException e) {
                throw new PluginRepositoryException("Cannot destroy plugin " + ruleParserPlugin);
            }
        }
    }

    private List<RuleSource> getRuleSources(List<JqassistantPlugin> plugins) {
        ArrayList<RuleSource> sources = new ArrayList<RuleSource>();
        for (JqassistantPlugin plugin : plugins) {
            RulesType rulesType = plugin.getRules();
            if (rulesType == null) continue;
            for (String relativePath : rulesType.getResource()) {
                sources.add((RuleSource)new ClasspathRuleSource(this.classLoader, relativePath));
            }
        }
        return sources;
    }
}

