/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.runtime.api.bootstrap;

import com.buschmais.jqassistant.core.analysis.api.configuration.Analyze;
import com.buschmais.jqassistant.core.rule.api.RuleHelper;
import com.buschmais.jqassistant.core.rule.api.executor.CollectRulesVisitor;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.RuleSelection;
import com.buschmais.jqassistant.core.rule.api.model.RuleSet;
import com.buschmais.jqassistant.core.rule.api.source.FileRuleSource;
import com.buschmais.jqassistant.core.rule.api.source.RuleSource;
import com.buschmais.jqassistant.core.rule.impl.reader.RuleParser;
import com.buschmais.jqassistant.core.runtime.api.configuration.Configuration;
import com.buschmais.jqassistant.core.runtime.api.plugin.PluginRepository;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class RuleProvider {
    private final Configuration configuration;
    private final PluginRepository pluginRepository;
    private final List<RuleSource> ruleSources;
    private final RuleSet availableRules;
    private final CollectRulesVisitor effectiveRules;

    public static RuleProvider create(Configuration configuration, String defaultRuleDirectory, PluginRepository pluginRepository) throws RuleException {
        return new RuleProvider(configuration, pluginRepository, defaultRuleDirectory);
    }

    private RuleProvider(Configuration configuration, PluginRepository pluginRepository, String defaultRuleDirectory) throws RuleException {
        this.configuration = configuration;
        this.pluginRepository = pluginRepository;
        this.ruleSources = this.initRuleSources(defaultRuleDirectory);
        this.availableRules = this.initAvailableRules();
        this.effectiveRules = this.initEffectiveRules();
    }

    private List<RuleSource> initRuleSources(String defaultRuleDirectory) throws RuleException {
        ArrayList<RuleSource> sources = new ArrayList<RuleSource>();
        sources.addAll(this.readRulesDirectory(defaultRuleDirectory));
        sources.addAll(this.pluginRepository.getRulePluginRepository().getRuleSources());
        return sources;
    }

    private List<RuleSource> readRulesDirectory(String defaultRuleDirectory) throws RuleException {
        File rulesDirectory = new File(this.configuration.analyze().rule().directory().orElse(defaultRuleDirectory));
        if (rulesDirectory.exists() && !rulesDirectory.isDirectory()) {
            throw new RuleException(rulesDirectory.getAbsolutePath() + " is not a directory.");
        }
        try {
            return FileRuleSource.getRuleSources((File)rulesDirectory);
        }
        catch (IOException e) {
            throw new RuleException("Cannot read rules directory: " + rulesDirectory.getAbsolutePath(), (Throwable)e);
        }
    }

    private RuleSet initAvailableRules() throws RuleException {
        Collection ruleParserPlugins = this.pluginRepository.getRulePluginRepository().getRuleParserPlugins(this.configuration.analyze().rule());
        RuleParser ruleParser = new RuleParser(ruleParserPlugins);
        return ruleParser.parse(this.ruleSources);
    }

    private CollectRulesVisitor initEffectiveRules() throws RuleException {
        Analyze analyze = this.configuration.analyze();
        RuleSelection selection = RuleSelection.select((RuleSet)this.availableRules, (Optional)analyze.groups(), (Optional)analyze.constraints(), (Optional)analyze.excludeConstraints(), (Optional)analyze.concepts());
        RuleHelper ruleHelper = new RuleHelper();
        try {
            return ruleHelper.getAllRules(this.availableRules, selection, this.configuration.analyze().rule());
        }
        catch (RuleException e) {
            throw new RuleException(e.getMessage());
        }
    }

    @Generated
    public List<RuleSource> getRuleSources() {
        return this.ruleSources;
    }

    @Generated
    public RuleSet getAvailableRules() {
        return this.availableRules;
    }

    @Generated
    public CollectRulesVisitor getEffectiveRules() {
        return this.effectiveRules;
    }
}

