/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.runtime.api.bootstrap;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VersionProvider.class);
    private static final String PROPERTIES_FILE = "/META-INF/jqassistant.properties";
    private static final String MINOR_VERSION = "jqassistant.version.minor";
    private static final String MAJOR_VERSION = "jqassistant.version.major";
    private static final String VERSION = "jqassistant.version";
    private static final VersionProvider INSTANCE = new VersionProvider();
    private final String minorVersion;
    private final String majorVersion;
    private final String version;

    public static VersionProvider getVersionProvider() {
        return INSTANCE;
    }

    private VersionProvider() {
        Properties props = new Properties();
        InputStream inputStream = VersionProvider.class.getResourceAsStream(PROPERTIES_FILE);
        if (inputStream == null) {
            log.warn("Properties file not found: /META-INF/jqassistant.properties");
        }
        try {
            props.load(inputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load input stream from /META-INF/jqassistant.properties", e);
        }
        this.minorVersion = props.getProperty(MINOR_VERSION);
        this.majorVersion = props.getProperty(MAJOR_VERSION);
        this.version = props.getProperty(VERSION);
    }

    @Generated
    public String getMinorVersion() {
        return this.minorVersion;
    }

    @Generated
    public String getMajorVersion() {
        return this.majorVersion;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }
}

