/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.runtime.api.configuration;

import com.buschmais.jqassistant.core.runtime.api.bootstrap.VersionProvider;
import com.buschmais.jqassistant.core.shared.annotation.Description;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.CustomDefinition;
import com.github.victools.jsonschema.generator.CustomDefinitionProviderV2;
import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaBuilder;
import com.github.victools.jsonschema.generator.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaKeyword;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.google.common.base.CaseFormat;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import io.smallrye.config.WithDefault;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class JsonSchemaGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonSchemaGenerator.class);

    public static ObjectNode generateSchema(Class<?> clazz) {
        SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2019_09, OptionPreset.JAVA_OBJECT).with(Option.NONSTATIC_NONVOID_NONGETTER_METHODS, new Option[]{Option.PLAIN_DEFINITION_KEYS, Option.FORBIDDEN_ADDITIONAL_PROPERTIES_BY_DEFAULT, Option.FIELDS_DERIVED_FROM_ARGUMENTFREE_METHODS, Option.FLATTENED_ENUMS, Option.ALLOF_CLEANUP_AT_THE_END}).without(Option.VOID_METHODS, new Option[]{Option.GETTER_METHODS, Option.PUBLIC_STATIC_FIELDS});
        configBuilder.forMethods().withTargetTypeOverridesResolver(target -> JsonSchemaGenerator.getResolvedTypes(target, target.getType())).withPropertyNameOverrideResolver(member -> JsonSchemaGenerator.mapToKebabCase(member.getName())).withDefaultResolver(method -> {
            WithDefault annotation = (WithDefault)method.getAnnotationConsideringFieldAndGetter(WithDefault.class);
            if (annotation != null) {
                return annotation.value();
            }
            return null;
        }).withDescriptionResolver(method -> {
            Description innerAnnotation;
            Description annotation = (Description)method.getAnnotationConsideringFieldAndGetter(Description.class);
            if (annotation != null) {
                return annotation.value();
            }
            if (method.getType() != null && (innerAnnotation = method.getType().getErasedType().getAnnotation(Description.class)) != null) {
                return innerAnnotation.value();
            }
            return null;
        });
        configBuilder.forTypesInGeneral().withCustomDefinitionProvider((CustomDefinitionProviderV2)new MapDefinitionProvider()).withDefinitionNamingStrategy((definitionKey, context) -> JsonSchemaGenerator.mapToKebabCase(definitionKey.getType().getTypeName()));
        SchemaGenerator generatorNew = new SchemaGenerator(configBuilder.build());
        SchemaBuilder schemaBuilder = generatorNew.buildMultipleSchemaDefinitions();
        schemaBuilder.createSchemaReference(clazz, new Type[0]);
        ObjectNode schema = schemaBuilder.createSchemaReference(clazz, new Type[0]);
        ObjectNode definitions = schemaBuilder.collectDefinitions("$defs");
        return JsonSchemaGenerator.wrapJqassistant(schema, definitions);
    }

    private static ObjectNode wrapJqassistant(ObjectNode properties, ObjectNode definitions) {
        ObjectNode jqaWrapper = JsonNodeFactory.instance.objectNode();
        ObjectNode definitionWrapper = JsonNodeFactory.instance.objectNode();
        ObjectNode profileWrapper = JsonNodeFactory.instance.objectNode();
        ObjectNode patternPropertiesWrapper = JsonNodeFactory.instance.objectNode();
        jqaWrapper.set("jqassistant", (JsonNode)properties);
        profileWrapper.put("type", "object");
        profileWrapper.set("properties", (JsonNode)jqaWrapper);
        patternPropertiesWrapper.set("^%.*$", (JsonNode)profileWrapper);
        definitionWrapper.set("$defs", (JsonNode)definitions);
        definitionWrapper.put("type", "object");
        definitionWrapper.set("properties", (JsonNode)jqaWrapper);
        definitionWrapper.set("patternProperties", (JsonNode)patternPropertiesWrapper);
        return definitionWrapper;
    }

    private static List<ResolvedType> getResolvedTypes(MethodScope target, ResolvedType resolvedType) {
        if (resolvedType != null) {
            if (resolvedType.getErasedType().equals(URI.class) || resolvedType.getErasedType().equals(File.class) || resolvedType.getErasedType().equals(ZonedDateTime.class)) {
                return List.of(target.getContext().resolve(String.class, new Type[0]));
            }
            if (resolvedType.getErasedType().equals(Optional.class)) {
                return JsonSchemaGenerator.getResolvedTypes(target, (ResolvedType)resolvedType.getTypeParameters().get(0));
            }
        }
        return List.of(target.getContext().resolve((Type)resolvedType, new Type[0]));
    }

    private static String mapToKebabCase(String name) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, name);
    }

    public static File writeSchema(ObjectNode schema, File directory, String fileNamePrefix) throws IOException {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String fileName = fileNamePrefix + "-v" + VersionProvider.getVersionProvider().getMajorVersion() + "." + VersionProvider.getVersionProvider().getMinorVersion() + ".schema.json";
        File file = new File(directory, fileName);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.writerWithDefaultPrettyPrinter().writeValue(file, (Object)schema);
        log.info("Schema saved: " + file.getAbsolutePath());
        return file;
    }

    public static Set<ValidationMessage> validateYaml(URL configResource, JsonNode schemaNode) throws Exception {
        Map yamlData;
        JsonSchemaFactory bluePrintFactory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V201909);
        JsonSchemaFactory schemaFactory = JsonSchemaFactory.builder((JsonSchemaFactory)bluePrintFactory).build();
        JsonSchema schema = schemaFactory.getSchema(schemaNode);
        ObjectMapper objectMapper = new ObjectMapper();
        Yaml yaml = new Yaml();
        try (InputStream inputStream = configResource.openStream();){
            yamlData = (Map)yaml.load(inputStream);
        }
        String jsonString = objectMapper.writeValueAsString((Object)yamlData);
        Set validationMessages = schema.validate(objectMapper.readTree(jsonString));
        if (!validationMessages.isEmpty()) {
            log.error(validationMessages.toString());
        }
        return validationMessages;
    }

    @Generated
    private JsonSchemaGenerator() {
    }

    public static class MapDefinitionProvider
    implements CustomDefinitionProviderV2 {
        public CustomDefinition provideCustomSchemaDefinition(ResolvedType targetType, SchemaGenerationContext context) {
            if (!targetType.isInstanceOf(Map.class)) {
                return null;
            }
            ResolvedType keyType = context.getTypeContext().getTypeParameterFor(targetType, Map.class, 0);
            ResolvedType valueType = context.getTypeContext().getTypeParameterFor(targetType, Map.class, 1);
            if (keyType == null || !keyType.isInstanceOf(String.class)) {
                return null;
            }
            if (valueType == null) {
                valueType = context.getTypeContext().resolve(Object.class, new Type[0]);
            }
            ObjectNode customSchema = context.getGeneratorConfig().createObjectNode();
            customSchema.put(context.getKeyword(SchemaKeyword.TAG_TYPE), "object");
            ObjectNode unknownNameWrapper = context.getGeneratorConfig().createObjectNode();
            ObjectNode valueTypeDefinition = context.createDefinition(valueType);
            unknownNameWrapper.set("^.*$", (JsonNode)valueTypeDefinition);
            customSchema.set(context.getKeyword(SchemaKeyword.TAG_PATTERN_PROPERTIES), (JsonNode)unknownNameWrapper);
            return new CustomDefinition(customSchema);
        }
    }
}

