/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.runtime.impl.plugin;

import com.buschmais.jqassistant.core.runtime.api.plugin.PluginConfigurationReader;
import com.buschmais.jqassistant.core.runtime.api.plugin.PluginRepositoryException;
import java.util.List;
import org.jqassistant.schema.plugin.v2.JqassistantPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPluginRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPluginRepository.class);
    protected final List<JqassistantPlugin> plugins;
    protected final ClassLoader classLoader;

    protected AbstractPluginRepository(PluginConfigurationReader pluginConfigurationReader) {
        this.plugins = pluginConfigurationReader.getPlugins();
        this.classLoader = pluginConfigurationReader.getClassLoader();
        LOGGER.debug("Using classloader '{}'", (Object)this.classLoader);
    }

    protected <T> Class<T> getType(String typeName) {
        try {
            return this.classLoader.loadClass(typeName.trim());
        }
        catch (ClassNotFoundException | LinkageError e) {
            throw new PluginRepositoryException("Cannot find or load class " + typeName, e);
        }
    }

    protected <T> T createInstance(String typeName) {
        Class<T> type = this.getType(typeName.trim());
        try {
            return type.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new PluginRepositoryException("Cannot load or create instance of class " + type.getName(), e);
        }
    }
}

