/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.runtime.impl.plugin;

import com.buschmais.jqassistant.core.runtime.api.plugin.PluginClassLoader;
import com.buschmais.jqassistant.core.runtime.api.plugin.PluginConfigurationReader;
import com.buschmais.jqassistant.core.runtime.impl.plugin.PluginIdGenerator;
import com.buschmais.jqassistant.core.shared.xml.JAXBHelper;
import com.buschmais.jqassistant.core.shared.xml.XmlHelper;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import javax.xml.validation.Schema;
import org.jqassistant.schema.plugin.v2.JqassistantPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginConfigurationReaderImpl
implements PluginConfigurationReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginConfigurationReaderImpl.class);
    private static final Schema SCHEMA = XmlHelper.getSchema((String)"/META-INF/schema/jqassistant-plugin-v2.4.xsd");
    private final ClassLoader pluginClassLoader;
    private final JAXBHelper<JqassistantPlugin> jaxbHelper;
    private List<JqassistantPlugin> plugins = null;

    public PluginConfigurationReaderImpl(PluginClassLoader pluginClassLoader) {
        this.pluginClassLoader = pluginClassLoader;
        this.jaxbHelper = new JAXBHelper(JqassistantPlugin.class, SCHEMA, "http://schema.jqassistant.org/plugin/v2.4");
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.pluginClassLoader;
    }

    protected JqassistantPlugin readPlugin(URL pluginUrl) {
        try {
            return (JqassistantPlugin)this.jaxbHelper.unmarshal(pluginUrl);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read plugin from " + String.valueOf(pluginUrl), e);
        }
    }

    @Override
    public List<JqassistantPlugin> getPlugins() {
        if (this.plugins == null) {
            LOGGER.info("Scanning for jQAssistant plugins...");
            PluginIdGenerator idGenerator = new PluginIdGenerator();
            TreeSet<String> ids = new TreeSet<String>();
            Enumeration<URL> resources = this.getPluginClassLoaderResources();
            this.plugins = new ArrayList<JqassistantPlugin>();
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                LOGGER.debug("Reading plugin descriptor from '{}'.", (Object)url);
                JqassistantPlugin plugin = idGenerator.apply(this.readPlugin(url));
                if (ids.add(plugin.getId())) {
                    this.plugins.add(plugin);
                    continue;
                }
                JqassistantPlugin loadedPlugin = this.plugins.stream().filter(p -> p.getId().equals(plugin.getId())).findFirst().get();
                LOGGER.warn("Skipping plugin '{}' with id '{}' as it uses the same id as the already loaded plugin '{}'.", new Object[]{plugin.getName(), plugin.getId(), loadedPlugin.getName()});
            }
        }
        return this.plugins;
    }

    protected Enumeration<URL> getPluginClassLoaderResources() {
        try {
            return this.pluginClassLoader.getResources("META-INF/jqassistant-plugin.xml");
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot get plugin resources.", e);
        }
    }
}

