/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.runtime.impl.plugin;

import com.buschmais.jqassistant.core.analysis.spi.AnalyzerPluginRepository;
import com.buschmais.jqassistant.core.rule.spi.RulePluginRepository;
import com.buschmais.jqassistant.core.runtime.api.plugin.PluginConfigurationReader;
import com.buschmais.jqassistant.core.runtime.api.plugin.PluginInfo;
import com.buschmais.jqassistant.core.runtime.api.plugin.PluginRepository;
import com.buschmais.jqassistant.core.runtime.impl.plugin.AnalyzerPluginRepositoryImpl;
import com.buschmais.jqassistant.core.runtime.impl.plugin.PluginInfoImpl;
import com.buschmais.jqassistant.core.runtime.impl.plugin.RulePluginRepositoryImpl;
import com.buschmais.jqassistant.core.runtime.impl.plugin.ScannerPluginRepositoryImpl;
import com.buschmais.jqassistant.core.runtime.impl.plugin.StorePluginRepositoryImpl;
import com.buschmais.jqassistant.core.scanner.spi.ScannerPluginRepository;
import com.buschmais.jqassistant.core.store.spi.StorePluginRepository;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginRepositoryImpl
implements PluginRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PluginRepositoryImpl.class);
    private final PluginConfigurationReader pluginConfigurationReader;
    private StorePluginRepository storePluginRepository;
    private ScannerPluginRepository scannerPluginRepository;
    private RulePluginRepository rulePluginRepository;
    private AnalyzerPluginRepository analyzerPluginRepository;
    private ClassLoader classLoader;

    public PluginRepositoryImpl(PluginConfigurationReader pluginConfigurationReader) {
        this.pluginConfigurationReader = pluginConfigurationReader;
        this.printPluginInfos();
    }

    @Override
    public void initialize() {
        this.storePluginRepository = new StorePluginRepositoryImpl(this.pluginConfigurationReader);
        this.scannerPluginRepository = new ScannerPluginRepositoryImpl(this.pluginConfigurationReader);
        this.scannerPluginRepository.initialize();
        this.rulePluginRepository = new RulePluginRepositoryImpl(this.pluginConfigurationReader);
        this.rulePluginRepository.initialize();
        this.analyzerPluginRepository = new AnalyzerPluginRepositoryImpl(this.pluginConfigurationReader);
        this.analyzerPluginRepository.initialize();
        this.classLoader = this.pluginConfigurationReader.getClassLoader();
    }

    @Override
    public void destroy() {
        Optional.ofNullable(this.scannerPluginRepository).ifPresent(ScannerPluginRepository::destroy);
        Optional.ofNullable(this.rulePluginRepository).ifPresent(RulePluginRepository::destroy);
        Optional.ofNullable(this.analyzerPluginRepository).ifPresent(AnalyzerPluginRepository::destroy);
        Optional.ofNullable(this.storePluginRepository).ifPresent(StorePluginRepository::destroy);
    }

    @Override
    public StorePluginRepository getStorePluginRepository() {
        return this.storePluginRepository;
    }

    @Override
    public ScannerPluginRepository getScannerPluginRepository() {
        return this.scannerPluginRepository;
    }

    @Override
    public RulePluginRepository getRulePluginRepository() {
        return this.rulePluginRepository;
    }

    @Override
    public AnalyzerPluginRepository getAnalyzerPluginRepository() {
        return this.analyzerPluginRepository;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public List<PluginInfo> getPluginInfos() {
        return this.pluginConfigurationReader.getPlugins().stream().map(plugin -> PluginInfoImpl.builder().id(plugin.getId()).name(plugin.getName()).version(Optional.ofNullable(plugin.getVersion())).build()).sorted(PluginInfo.ID_COMPARATOR).collect(Collectors.toList());
    }

    @Override
    public void printPluginInfos() {
        for (PluginInfo pluginInfo : this.getPluginInfos()) {
            log.info("{} {} [{}]", new Object[]{pluginInfo.getName(), pluginInfo.getVersion().orElse("<unknown version>"), pluginInfo.getId()});
        }
    }
}

