/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.runtime.impl.plugin;

import com.buschmais.jqassistant.core.runtime.api.configuration.Configuration;
import com.buschmais.jqassistant.core.runtime.api.plugin.PluginClassLoader;
import com.buschmais.jqassistant.core.runtime.api.plugin.PluginRepositoryException;
import com.buschmais.jqassistant.core.runtime.api.plugin.PluginResolver;
import com.buschmais.jqassistant.core.shared.aether.configuration.Plugin;
import com.buschmais.jqassistant.core.shared.artifact.ArtifactProvider;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginResolverImpl
implements PluginResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PluginResolverImpl.class);
    private final ArtifactProvider artifactProvider;

    @Override
    public PluginClassLoader createClassLoader(ClassLoader parent, Configuration configuration) {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        plugins.addAll(configuration.defaultPlugins());
        plugins.addAll(configuration.plugins());
        if (!plugins.isEmpty()) {
            log.info("Resolving {} plugins and required dependencies.", (Object)plugins.size());
            List files = this.artifactProvider.resolve(plugins);
            return new PluginClassLoader(parent, this.getDependencyURLs(files));
        }
        return new PluginClassLoader(parent);
    }

    private List<URL> getDependencyURLs(List<File> files) {
        return files.stream().map(file -> {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new PluginRepositoryException("Cannot convert file " + String.valueOf(file) + " to URL", e);
            }
        }).collect(Collectors.toList());
    }

    @Generated
    public PluginResolverImpl(ArtifactProvider artifactProvider) {
        this.artifactProvider = artifactProvider;
    }
}

