/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.scanner.api;

import com.buschmais.jqassistant.core.scanner.api.Scope;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class ScopeHelper {
    public static final String SCOPE_SEPARATOR = "::";
    private final Logger logger;

    public ScopeHelper(Logger log) {
        this.logger = log;
    }

    public void printScopes(Map<String, Scope> scopes) {
        this.logger.info("Scopes [" + scopes.size() + "]");
        for (String scopeName : scopes.keySet()) {
            this.logger.info("\t" + scopeName);
        }
    }

    public List<ScopedResource> getScopedResources(String resources) {
        return resources != null ? this.getScopedResources(Arrays.asList(resources.split(","))) : Collections.emptyList();
    }

    public List<ScopedResource> getScopedResources(List<String> resources) {
        return resources.stream().map(resource -> {
            String[] segments = resource.trim().split(SCOPE_SEPARATOR);
            if (segments.length == 2) {
                return ScopedResource.builder().resource(segments[1]).scopeName(segments[0]).build();
            }
            return ScopedResource.builder().resource(segments[0]).build();
        }).collect(Collectors.toList());
    }

    public static class ScopedResource {
        private String resource;
        private String scopeName;

        ScopedResource(String resource, String scopeName) {
            this.resource = resource;
            this.scopeName = scopeName;
        }

        public static ScopedResourceBuilder builder() {
            return new ScopedResourceBuilder();
        }

        public String getResource() {
            return this.resource;
        }

        public String getScopeName() {
            return this.scopeName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScopedResource)) {
                return false;
            }
            ScopedResource other = (ScopedResource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$resource = this.getResource();
            String other$resource = other.getResource();
            if (this$resource == null ? other$resource != null : !this$resource.equals(other$resource)) {
                return false;
            }
            String this$scopeName = this.getScopeName();
            String other$scopeName = other.getScopeName();
            return !(this$scopeName == null ? other$scopeName != null : !this$scopeName.equals(other$scopeName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ScopedResource;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $resource = this.getResource();
            result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
            String $scopeName = this.getScopeName();
            result = result * 59 + ($scopeName == null ? 43 : $scopeName.hashCode());
            return result;
        }

        public String toString() {
            return "ScopeHelper.ScopedResource(resource=" + this.getResource() + ", scopeName=" + this.getScopeName() + ")";
        }

        public static class ScopedResourceBuilder {
            private String resource;
            private String scopeName;

            ScopedResourceBuilder() {
            }

            public ScopedResourceBuilder resource(String resource) {
                this.resource = resource;
                return this;
            }

            public ScopedResourceBuilder scopeName(String scopeName) {
                this.scopeName = scopeName;
                return this;
            }

            public ScopedResource build() {
                return new ScopedResource(this.resource, this.scopeName);
            }

            public String toString() {
                return "ScopeHelper.ScopedResource.ScopedResourceBuilder(resource=" + this.resource + ", scopeName=" + this.scopeName + ")";
            }
        }
    }
}

