/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.scanner.impl;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import java.io.File;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScannerContextImpl
implements ScannerContext {
    private static final Logger log = LoggerFactory.getLogger(ScannerContextImpl.class);
    private final ClassLoader classLoader;
    private final Store store;
    private final File workingDirectory;
    private final File dataDirectory;
    private Descriptor current;
    private final Map<Class<?>, Deque<?>> contextValuesPerKey = new HashMap();

    public ScannerContextImpl(ClassLoader classLoader, Store store, File workingDirectory, File outputDirectory) {
        this.classLoader = classLoader;
        this.store = store;
        this.workingDirectory = workingDirectory;
        this.dataDirectory = new File(outputDirectory, "data");
    }

    @Override
    public <T> void push(Class<T> key, T value) {
        this.getValues(key).push(value);
    }

    @Override
    public <T> T peek(Class<T> key) {
        T value = this.getValues(key).peek();
        if (value == null) {
            throw new IllegalStateException("Cannot find a value for '" + key.getName() + "' in the context");
        }
        return value;
    }

    @Override
    public <T> T peekOrDefault(Class<T> key, T defaultValue) {
        T value = this.getValues(key).peek();
        return value != null ? value : defaultValue;
    }

    @Override
    public <T> T pop(Class<T> key) {
        return this.getValues(key).pop();
    }

    @Override
    public <D extends Descriptor> void setCurrentDescriptor(D descriptor) {
        this.current = descriptor;
    }

    @Override
    public <D extends Descriptor> D getCurrentDescriptor() {
        return (D)this.current;
    }

    private <T> Deque<T> getValues(Class<T> key) {
        return this.contextValuesPerKey.computeIfAbsent(key, k -> new LinkedList());
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Store getStore() {
        return this.store;
    }

    @Override
    public File getDataDirectory(String path) {
        File directory = new File(this.dataDirectory, path);
        if (directory.mkdirs()) {
            log.debug("Created data directory '{}'.", (Object)directory.getAbsolutePath());
        }
        return directory;
    }

    @Override
    public File getWorkingDirectory() {
        return this.workingDirectory;
    }
}

