/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.scanner.api.configuration;

import com.buschmais.jqassistant.core.scanner.api.configuration.Include;
import com.buschmais.jqassistant.core.shared.annotation.Description;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import java.util.Map;
import java.util.Optional;

@ConfigMapping(prefix="jqassistant.scan")
public interface Scan {
    public static final String RESET = "reset";
    public static final String CONTINUE_ON_ERROR = "continue-on-error";
    public static final String INCLUDE = "include";
    public static final String PROPERTIES = "properties";

    @Description(value="Indicates whether to initially reset the store (i.e. clear all nodes and relationships) before scanning.")
    public Optional<Boolean> reset();

    @Description(value="Specifies if a scan shall be continued if an error is encountered.")
    @WithDefault(value="false")
    public boolean continueOnError();

    @Description(value="The items to include for scanning.")
    public Optional<Include> include();

    @Description(value="The properties to configure scanner plugins. The supported properties are plugin specific.")
    public Map<String, String> properties();
}

