/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.scanner.impl;

import com.buschmais.jqassistant.core.scanner.api.DefaultScope;
import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.scanner.api.configuration.Scan;
import com.buschmais.jqassistant.core.scanner.impl.UnrecoverableScannerException;
import com.buschmais.jqassistant.core.scanner.spi.ScannerPluginRepository;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.xo.spi.reflection.DependencyResolver;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScannerImpl
implements Scanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScannerImpl.class);
    private final Scan configuration;
    private final ScannerContext scannerContext;
    private final ScannerPluginRepository scannerPluginRepository;
    private final Set<ScannerPlugin<?, ?>> scannerPlugins;
    private final Map<Class<?>, List<ScannerPlugin<?, ?>>> scannerPluginsPerType = new HashMap();
    private final Map<Object, Set<ScannerPlugin<?, ?>>> pipelines = new IdentityHashMap();

    public ScannerImpl(Scan configuration, ScannerContext scannerContext, ScannerPluginRepository scannerPluginRepository) {
        this.configuration = configuration;
        this.scannerContext = scannerContext;
        this.scannerPluginRepository = scannerPluginRepository;
        this.scannerPlugins = scannerPluginRepository.getScannerPlugins(configuration, scannerContext);
        this.scannerContext.push(Scope.class, null);
    }

    @Override
    public Scan getConfiguration() {
        return this.configuration;
    }

    @Override
    public <I, D extends Descriptor> D scan(I item, String path, Scope scope) {
        return this.scan(item, null, path, scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <I, D extends Descriptor> D scan(I item, D descriptor, String path, Scope scope) {
        block13: {
            boolean pipelineCreated;
            Set<ScannerPlugin<?, ?>> pipeline = this.pipelines.get(item);
            if (pipeline == null) {
                pipeline = new LinkedHashSet();
                this.pipelines.put(item, pipeline);
                pipelineCreated = true;
            } else {
                pipelineCreated = false;
            }
            Store store = this.scannerContext.getStore();
            try {
                if (!store.hasActiveTransaction()) {
                    store.beginTransaction();
                    descriptor = this.scan(item, descriptor, path, scope, pipeline);
                    store.commitTransaction();
                } else {
                    descriptor = this.scan(item, descriptor, path, scope, pipeline);
                }
            }
            catch (UnrecoverableScannerException e) {
                throw e;
            }
            catch (RuntimeException e) {
                if (store.hasActiveTransaction()) {
                    store.rollbackTransaction();
                }
                String message = "Unexpected problem encountered while scanning: item='" + String.valueOf(item) + "', path='" + path + "', scope='" + String.valueOf(scope) + "', pipeline='" + String.valueOf(pipeline) + "'. Please report this error including the full stacktrace (continueOnError=" + this.configuration.continueOnError() + ").";
                if (this.configuration.continueOnError()) {
                    LOGGER.error(message, (Throwable)e);
                    LOGGER.info("Continuing scan after error. NOTE: Data might be inconsistent.");
                    break block13;
                }
                throw new UnrecoverableScannerException(message, e);
            }
            finally {
                if (pipelineCreated) {
                    this.pipelines.remove(item);
                }
            }
        }
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <I, D extends Descriptor> D scan(I item, D descriptor, String path, Scope scope, Set<ScannerPlugin<?, ?>> pipeline) {
        Class<?> itemClass = item.getClass();
        Class<?> type = null;
        for (ScannerPlugin<?, ?> scannerPlugin : this.getScannerPluginsForType(itemClass)) {
            ScannerPlugin<?, ?> selectedPlugin = scannerPlugin;
            if (pipeline.contains(selectedPlugin) || !this.accepts(selectedPlugin, item, path, scope) || !this.satisfies(selectedPlugin, descriptor)) continue;
            pipeline.add(selectedPlugin);
            this.pushDesriptor(type, descriptor);
            Object newDescriptor = null;
            try {
                newDescriptor = selectedPlugin.scan(item, path, scope, this);
            }
            catch (IOException e) {
                LOGGER.warn("Cannot scan item " + path, (Throwable)e);
            }
            finally {
                this.popDescriptor(type, descriptor);
                descriptor = newDescriptor;
                type = selectedPlugin.getDescriptorType();
            }
        }
        return descriptor;
    }

    private <I, D extends Descriptor> boolean satisfies(ScannerPlugin<I, D> selectedPlugin, D descriptor) {
        return !selectedPlugin.getClass().isAnnotationPresent(ScannerPlugin.Requires.class) || descriptor != null;
    }

    protected <I> boolean accepts(ScannerPlugin<I, ?> selectedPlugin, I item, String path, Scope scope) {
        boolean accepted = false;
        try {
            accepted = selectedPlugin.accepts(item, path, scope);
        }
        catch (IOException e) {
            LOGGER.error("Plugin " + String.valueOf(selectedPlugin) + " failed to check whether it can accept item " + path, (Throwable)e);
        }
        return accepted;
    }

    private <D extends Descriptor> void pushDesriptor(Class<D> type, D descriptor) {
        if (descriptor != null) {
            this.scannerContext.push(type, descriptor);
            this.scannerContext.setCurrentDescriptor(descriptor);
        }
    }

    private <D extends Descriptor> void popDescriptor(Class<D> type, D descriptor) {
        if (descriptor != null) {
            this.scannerContext.setCurrentDescriptor(null);
            this.scannerContext.pop(type);
        }
    }

    @Override
    public ScannerContext getContext() {
        return this.scannerContext;
    }

    @Override
    public Scope resolveScope(String name) {
        if (name == null) {
            return DefaultScope.NONE;
        }
        Scope scope = this.scannerPluginRepository.getScopes().get(name);
        if (scope == null) {
            LOGGER.warn("No scope found for name '{}'.", (Object)name);
            scope = DefaultScope.NONE;
        }
        return scope;
    }

    private List<ScannerPlugin<?, ?>> getScannerPluginsForType(Class<?> type) {
        List plugins = this.scannerPluginsPerType.get(type);
        if (plugins == null) {
            LinkedList candidates = new LinkedList();
            HashMap<Class, Set> pluginsByDescriptor = new HashMap<Class, Set>();
            for (ScannerPlugin<?, ?> scannerPlugin : this.scannerPlugins) {
                Class<?> scannerPluginType = scannerPlugin.getType();
                if (!scannerPluginType.isAssignableFrom(type)) continue;
                Class<?> descriptorType = scannerPlugin.getDescriptorType();
                Set pluginsForDescriptorType = pluginsByDescriptor.computeIfAbsent(descriptorType, k -> new HashSet());
                pluginsForDescriptorType.add(scannerPlugin);
                candidates.add(scannerPlugin);
            }
            plugins = DependencyResolver.newInstance(candidates, dependent -> {
                HashSet<ScannerPlugin> dependencies = new HashSet<ScannerPlugin>();
                ScannerPlugin.Requires annotation = dependent.getClass().getAnnotation(ScannerPlugin.Requires.class);
                if (annotation != null) {
                    for (Class<? extends Descriptor> descriptorType : annotation.value()) {
                        Set pluginsByDescriptorType = (Set)pluginsByDescriptor.get(descriptorType);
                        if (pluginsByDescriptorType == null) continue;
                        for (ScannerPlugin scannerPlugin : pluginsByDescriptorType) {
                            if (scannerPlugin.equals(dependent)) continue;
                            dependencies.add(scannerPlugin);
                        }
                    }
                }
                return dependencies;
            }).resolve();
            this.scannerPluginsPerType.put(type, plugins);
        }
        return plugins;
    }
}

