/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.shared.reflection;

public class ClassHelper {
    private ClassLoader classLoader;

    public ClassHelper(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public <T> Class<T> getType(String typeName) {
        try {
            return this.classLoader.loadClass(typeName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Cannot find class " + typeName, e);
        }
    }

    public <T> T createInstance(Class<T> type, String typeName) {
        try {
            return type.cast(this.getType(typeName).newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Cannot create instance of class " + type.getName(), e);
        }
    }

    public <T> T createInstance(Class<T> type) {
        try {
            return type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Cannot create instance of class " + type.getName(), e);
        }
    }
}

