/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.test.plugin;

import com.buschmais.jqassistant.core.analysis.api.Analyzer;
import com.buschmais.jqassistant.core.analysis.api.RuleInterpreterPlugin;
import com.buschmais.jqassistant.core.analysis.api.configuration.Analyze;
import com.buschmais.jqassistant.core.analysis.impl.AnalyzerImpl;
import com.buschmais.jqassistant.core.report.api.ReportContext;
import com.buschmais.jqassistant.core.report.api.ReportPlugin;
import com.buschmais.jqassistant.core.report.api.configuration.Report;
import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.report.impl.CompositeReportPlugin;
import com.buschmais.jqassistant.core.report.impl.InMemoryReportPlugin;
import com.buschmais.jqassistant.core.report.impl.ReportContextImpl;
import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.Constraint;
import com.buschmais.jqassistant.core.rule.api.model.Group;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.RuleSelection;
import com.buschmais.jqassistant.core.rule.api.model.RuleSet;
import com.buschmais.jqassistant.core.rule.api.source.FileRuleSource;
import com.buschmais.jqassistant.core.rule.impl.reader.RuleParser;
import com.buschmais.jqassistant.core.runtime.api.configuration.Configuration;
import com.buschmais.jqassistant.core.runtime.api.configuration.ConfigurationBuilder;
import com.buschmais.jqassistant.core.runtime.api.configuration.ConfigurationMappingLoader;
import com.buschmais.jqassistant.core.runtime.api.plugin.PluginClassLoader;
import com.buschmais.jqassistant.core.runtime.api.plugin.PluginConfigurationReader;
import com.buschmais.jqassistant.core.runtime.impl.plugin.PluginConfigurationReaderImpl;
import com.buschmais.jqassistant.core.runtime.impl.plugin.PluginRepositoryImpl;
import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.configuration.Scan;
import com.buschmais.jqassistant.core.scanner.impl.ScannerContextImpl;
import com.buschmais.jqassistant.core.scanner.impl.ScannerImpl;
import com.buschmais.jqassistant.core.scanner.spi.ScannerPluginRepository;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.StoreFactory;
import com.buschmais.jqassistant.core.store.api.configuration.Remote;
import com.buschmais.jqassistant.core.store.spi.StorePluginRepository;
import com.buschmais.xo.api.Query;
import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.SysPropConfigSource;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;

public abstract class AbstractPluginIT {
    public static final File TEST_STORE_DIRECTORY = new File("target/jqassistant/test-store");
    protected static final String ARTIFACT_ID = "artifact";
    private static final String STORE_URI_MEMORY = "memory:///";
    private static final String STORE_URI_REMOTE = "bolt://localhost:7687";
    private static PluginRepositoryImpl pluginRepository;
    private File workingDirectory;
    private File outputDirectory;
    private TestStore testStore;
    protected Store store;
    protected InMemoryReportPlugin reportPlugin;
    protected RuleSet ruleSet;

    @BeforeAll
    public static void initPluginRepository() {
        PluginClassLoader pluginClassLoader = new PluginClassLoader(AbstractPluginIT.class.getClassLoader());
        PluginConfigurationReaderImpl pluginConfigurationReader = new PluginConfigurationReaderImpl(pluginClassLoader);
        pluginRepository = new PluginRepositoryImpl((PluginConfigurationReader)pluginConfigurationReader);
        pluginRepository.initialize();
    }

    @AfterAll
    public static void destroyPluginRepository() {
        if (pluginRepository != null) {
            pluginRepository.destroy();
        }
    }

    @BeforeEach
    public void beforeEach(TestInfo testInfo) throws IOException, RuleException {
        Method method = (Method)testInfo.getTestMethod().orElseThrow(() -> new AssertionError((Object)("Unable to get the test method for test '" + testInfo.getDisplayName() + "'.")));
        this.testStore = method.getAnnotation(TestStore.class);
        ConfigurationBuilder configurationBuilder = this.createConfigurationBuilder();
        this.configure(configurationBuilder);
        Configuration configuration = this.createConfiguration(configurationBuilder);
        this.workingDirectory = new File(".");
        this.outputDirectory = new File(this.workingDirectory, "target/jqassistant");
        this.outputDirectory.mkdirs();
        this.startStore(configuration.store(), this.testStore);
        this.initializeRuleSet(configuration);
        this.initializeReportPlugin(configuration);
    }

    protected void configure(ConfigurationBuilder configurationBuilder) {
    }

    private ConfigurationBuilder createConfigurationBuilder() {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder("ITConfigSource", 110);
        TestStore.Type type = this.testStore != null ? this.testStore.type() : TestStore.Type.MEMORY;
        switch (type) {
            case FILE: {
                break;
            }
            case MEMORY: {
                try {
                    configurationBuilder.with(com.buschmais.jqassistant.core.store.api.configuration.Store.class, "uri", new URI(STORE_URI_MEMORY));
                    break;
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Cannot create store URI", e);
                }
            }
            case REMOTE: {
                try {
                    configurationBuilder.with(com.buschmais.jqassistant.core.store.api.configuration.Store.class, "uri", new URI(STORE_URI_REMOTE));
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Cannot create store URI", e);
                }
                configurationBuilder.with(Remote.class, "encryption", "NONE");
                configurationBuilder.with(Remote.class, "username", "neo4j");
                configurationBuilder.with(Remote.class, "password", "jqassistant");
                Properties properties = new Properties();
                properties.put("neo4j.remote.statement.log.level", "info");
                configurationBuilder.with(Remote.class, "properties", properties);
                break;
            }
            default: {
                throw new AssertionError((Object)("Test store type not supported: " + type));
            }
        }
        configurationBuilder.with(Report.class, "properties", this.getReportProperties());
        return configurationBuilder;
    }

    @AfterEach
    public void stopStore() {
        if (this.store != null) {
            this.store.stop();
        }
    }

    private Configuration createConfiguration(ConfigurationBuilder configurationBuilder) {
        return ConfigurationMappingLoader.builder(Configuration.class).load(new ConfigSource[]{configurationBuilder.build(), new EnvConfigSource(){}, new SysPropConfigSource()});
    }

    private void initializeRuleSet(Configuration configuration) throws RuleException, IOException {
        File selectedDirectory = new File(this.getClassesDirectory(this.getClass()), "rules");
        LinkedList sources = new LinkedList();
        if (selectedDirectory.exists()) {
            sources.addAll(FileRuleSource.getRuleSources((File)selectedDirectory));
        }
        sources.addAll(pluginRepository.getRulePluginRepository().getRuleSources());
        Collection ruleParserPlugins = pluginRepository.getRulePluginRepository().getRuleParserPlugins(configuration.analyze().rule());
        RuleParser ruleParser = new RuleParser(ruleParserPlugins);
        this.ruleSet = ruleParser.parse(sources);
    }

    private void initializeReportPlugin(Configuration configuration) {
        ReportContextImpl reportContext = new ReportContextImpl(pluginRepository.getClassLoader(), this.store, this.outputDirectory);
        Map reportPlugins = pluginRepository.getAnalyzerPluginRepository().getReportPlugins(configuration.analyze().report(), (ReportContext)reportContext);
        this.reportPlugin = new InMemoryReportPlugin((ReportPlugin)new CompositeReportPlugin(reportPlugins));
    }

    protected Map<String, Object> getScannerProperties() {
        return Collections.emptyMap();
    }

    protected Map<String, Object> getReportProperties() {
        return Collections.emptyMap();
    }

    protected Map<String, Collection<RuleInterpreterPlugin>> getRuleInterpreterPlugins() {
        return pluginRepository.getAnalyzerPluginRepository().getRuleInterpreterPlugins(this.getRuleInterpreterProperties());
    }

    protected Map<String, Object> getRuleInterpreterProperties() {
        return Collections.emptyMap();
    }

    private void startStore(com.buschmais.jqassistant.core.store.api.configuration.Store storeConfiguration, TestStore testStore) {
        this.store = StoreFactory.getStore((com.buschmais.jqassistant.core.store.api.configuration.Store)storeConfiguration, () -> TEST_STORE_DIRECTORY, (StorePluginRepository)pluginRepository.getStorePluginRepository(), plugins -> Collections.emptyList());
        this.store.start();
        if (testStore == null || testStore.reset()) {
            this.store.reset();
        }
    }

    protected Scanner getScanner() {
        return this.getScanner(this.getScannerProperties());
    }

    protected Scanner getScanner(Map<String, Object> properties) {
        ConfigurationBuilder configurationBuilder = this.createConfigurationBuilder().with(Scan.class, "properties", properties);
        Configuration configuration = this.createConfiguration(configurationBuilder);
        ScannerContextImpl scannerContext = new ScannerContextImpl(pluginRepository.getClassLoader(), this.store, this.workingDirectory, this.outputDirectory);
        ScannerPluginRepository scannerPluginRepository = pluginRepository.getScannerPluginRepository();
        return new ScannerImpl(configuration.scan(), (ScannerContext)scannerContext, scannerPluginRepository);
    }

    private Analyzer getAnalyzer(Map<String, String> parameters) throws RuleException {
        ConfigurationBuilder configurationBuilder = this.createConfigurationBuilder().with(Analyze.class, "rule-parameters", parameters);
        Configuration configuration = this.createConfiguration(configurationBuilder);
        return new AnalyzerImpl(configuration.analyze(), pluginRepository.getClassLoader(), this.store, this.getRuleInterpreterPlugins(), (ReportPlugin)this.reportPlugin);
    }

    protected File getClassesDirectory(Class<?> rootClass) {
        File directory = new File(rootClass.getClassLoader().getResource(".").getFile());
        Assertions.assertThat((File)directory).isDirectory().describedAs("Expected %s to be a directory", new Object[]{directory.toString()});
        return directory;
    }

    protected TestResult query(String query) {
        return this.query(query, Collections.emptyMap());
    }

    protected TestResult query(String query, Map<String, Object> parameters) {
        Query.Result compositeRowObjects = this.store.executeQuery(query, parameters);
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        HashMap<String, List<Object>> columns = new HashMap<String, List<Object>>();
        for (Query.Result.CompositeRowObject rowObject : compositeRowObjects) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            List columnNames = rowObject.getColumns();
            for (String columnName : columnNames) {
                ArrayList<Object> columnValues = (ArrayList<Object>)columns.get(columnName);
                if (columnValues == null) {
                    columnValues = new ArrayList<Object>();
                    columns.put(columnName, columnValues);
                }
                Object value = rowObject.get(columnName, Object.class);
                row.put(columnName, value);
                columnValues.add(value);
            }
            rows.add(row);
        }
        return new TestResult(rows, columns);
    }

    protected Result<Concept> applyConcept(String id) throws RuleException {
        return this.applyConcept(id, Collections.emptyMap());
    }

    protected Result<Concept> applyConcept(String id, Map<String, String> parameters) throws RuleException {
        Analyzer analyzer = this.getAnalyzer(parameters);
        RuleSelection ruleSelection = RuleSelection.builder().conceptId(id).build();
        Concept concept = (Concept)this.ruleSet.getConceptBucket().getById(id);
        ((ObjectAssert)Assertions.assertThat((Object)concept).describedAs("The requested concept cannot be found: " + id, new Object[0])).isNotNull();
        analyzer.execute(this.ruleSet, ruleSelection);
        return (Result)this.reportPlugin.getConceptResults().get(id);
    }

    protected Result<Constraint> validateConstraint(String id) throws RuleException {
        return this.validateConstraint(id, Collections.emptyMap());
    }

    protected Result<Constraint> validateConstraint(String id, Map<String, String> parameters) throws RuleException {
        RuleSelection ruleSelection = RuleSelection.builder().constraintId(id).build();
        Constraint constraint = (Constraint)this.ruleSet.getConstraintBucket().getById(id);
        ((ObjectAssert)Assertions.assertThat((Object)constraint).describedAs("The requested constraint cannot be found: " + id, new Object[0])).isNotNull();
        this.getAnalyzer(parameters).execute(this.ruleSet, ruleSelection);
        return (Result)this.reportPlugin.getConstraintResults().get(id);
    }

    protected void executeGroup(String id) throws RuleException {
        this.executeGroup(id, Collections.emptyMap());
    }

    protected void executeGroup(String id, Map<String, String> parameters) throws RuleException {
        RuleSelection ruleSelection = RuleSelection.builder().groupId(id).build();
        Group group = (Group)this.ruleSet.getGroupsBucket().getById(id);
        ((ObjectAssert)Assertions.assertThat((Object)group).describedAs("The request group cannot be found: " + id, new Object[0])).isNotNull();
        this.getAnalyzer(parameters).execute(this.ruleSet, ruleSelection);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    protected static @interface TestStore {
        public boolean reset() default true;

        public Type type() default Type.FILE;

        public static enum Type {
            FILE,
            MEMORY,
            REMOTE;

        }
    }

    protected class TestResult {
        private List<Map<String, Object>> rows;
        private Map<String, List<Object>> columns;

        public <T> List<T> getColumn(String name) {
            List<Object> column = this.columns.get(name);
            if (column == null) {
                throw new IllegalArgumentException("The result does not contain a column '" + name + "'.");
            }
            return column;
        }

        public List<Map<String, Object>> getRows() {
            return this.rows;
        }

        public Map<String, List<Object>> getColumns() {
            return this.columns;
        }

        private TestResult(List<Map<String, Object>> rows, Map<String, List<Object>> columns) {
            this.rows = rows;
            this.columns = columns;
        }

        public String toString() {
            return "AbstractPluginIT.TestResult(rows=" + this.getRows() + ", columns=" + this.getColumns() + ")";
        }
    }
}

