/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.test.plugin;

import com.buschmais.jqassistant.core.analysis.api.Analyzer;
import com.buschmais.jqassistant.core.analysis.api.RuleInterpreterPlugin;
import com.buschmais.jqassistant.core.analysis.api.baseline.BaselineManager;
import com.buschmais.jqassistant.core.analysis.api.baseline.BaselineRepository;
import com.buschmais.jqassistant.core.analysis.api.configuration.Analyze;
import com.buschmais.jqassistant.core.analysis.api.configuration.Baseline;
import com.buschmais.jqassistant.core.analysis.impl.AnalyzerImpl;
import com.buschmais.jqassistant.core.report.api.ReportContext;
import com.buschmais.jqassistant.core.report.api.ReportPlugin;
import com.buschmais.jqassistant.core.report.api.configuration.Report;
import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.report.impl.CompositeReportPlugin;
import com.buschmais.jqassistant.core.report.impl.InMemoryReportPlugin;
import com.buschmais.jqassistant.core.report.impl.ReportContextImpl;
import com.buschmais.jqassistant.core.resolver.api.ArtifactProviderFactory;
import com.buschmais.jqassistant.core.resolver.api.MavenSettingsConfigSourceBuilder;
import com.buschmais.jqassistant.core.resolver.configuration.ArtifactResolverConfiguration;
import com.buschmais.jqassistant.core.rule.api.annotation.ConceptId;
import com.buschmais.jqassistant.core.rule.api.annotation.ConstraintId;
import com.buschmais.jqassistant.core.rule.api.annotation.GroupId;
import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.Constraint;
import com.buschmais.jqassistant.core.rule.api.model.Group;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.RuleSelection;
import com.buschmais.jqassistant.core.rule.api.model.RuleSet;
import com.buschmais.jqassistant.core.rule.api.source.FileRuleSource;
import com.buschmais.jqassistant.core.rule.impl.reader.RuleParser;
import com.buschmais.jqassistant.core.runtime.api.configuration.Configuration;
import com.buschmais.jqassistant.core.runtime.api.plugin.PluginClassLoader;
import com.buschmais.jqassistant.core.runtime.api.plugin.PluginConfigurationReader;
import com.buschmais.jqassistant.core.runtime.impl.plugin.PluginConfigurationReaderImpl;
import com.buschmais.jqassistant.core.runtime.impl.plugin.PluginRepositoryImpl;
import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.configuration.Scan;
import com.buschmais.jqassistant.core.scanner.impl.ScannerContextImpl;
import com.buschmais.jqassistant.core.scanner.impl.ScannerImpl;
import com.buschmais.jqassistant.core.scanner.spi.ScannerPluginRepository;
import com.buschmais.jqassistant.core.shared.aether.AetherArtifactProvider;
import com.buschmais.jqassistant.core.shared.artifact.ArtifactProvider;
import com.buschmais.jqassistant.core.shared.configuration.ConfigurationBuilder;
import com.buschmais.jqassistant.core.shared.configuration.ConfigurationMappingLoader;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.StoreFactory;
import com.buschmais.jqassistant.core.test.plugin.ITConfiguration;
import com.buschmais.xo.api.Query;
import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.SysPropConfigSource;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;

public abstract class AbstractPluginIT {
    private static final String PROPERTY_MAVEN_SETTINGS = "jqassistant.it.maven-settings";
    private static final String PROPERTY_PROFILES = "jqassistant.it.profiles";
    private static final File USER_HOME = new File(System.getProperty("user.home"));
    private static final File WORKING_DIRECTORY = new File(".");
    private static final File OUTPUT_DIRECTORY = new File(WORKING_DIRECTORY, "target/jqassistant");
    private static final File TEST_STORE_DIRECTORY = new File("target/jqassistant/test-store");
    protected static final String ARTIFACT_ID = "artifact";
    private static ConfigSource mavenSettingsConfigSource;
    private static PluginRepositoryImpl pluginRepository;
    protected Store store;
    protected InMemoryReportPlugin reportPlugin;
    protected RuleSet ruleSet;

    @BeforeAll
    public static void initPluginRepository() {
        Optional<File> mavenSettingsFile = Optional.ofNullable(System.getProperty(PROPERTY_MAVEN_SETTINGS)).map(File::new);
        List profiles = Optional.ofNullable(System.getProperty(PROPERTY_PROFILES)).map(p -> List.of(p.split(","))).orElse(Collections.emptyList());
        mavenSettingsConfigSource = MavenSettingsConfigSourceBuilder.createMavenSettingsConfigSource((File)USER_HOME, mavenSettingsFile, profiles);
        PluginClassLoader pluginClassLoader = new PluginClassLoader(AbstractPluginIT.class.getClassLoader());
        PluginConfigurationReaderImpl pluginConfigurationReader = new PluginConfigurationReaderImpl(pluginClassLoader);
        pluginRepository = new PluginRepositoryImpl((PluginConfigurationReader)pluginConfigurationReader);
        pluginRepository.initialize();
        OUTPUT_DIRECTORY.mkdirs();
    }

    @AfterAll
    public static void destroyPluginRepository() {
        if (pluginRepository != null) {
            pluginRepository.destroy();
        }
    }

    @BeforeEach
    public void beforeEach() throws IOException, RuleException {
        ConfigurationBuilder configurationBuilder = this.createConfigurationBuilder();
        this.configure(configurationBuilder);
        ITConfiguration configuration = this.createConfiguration(configurationBuilder);
        this.startStore(configuration);
        this.initializeRuleSet(configuration);
        this.initializeReportPlugin(configuration);
    }

    protected void configure(ConfigurationBuilder configurationBuilder) {
    }

    protected List<String> getConfigurationProfiles() {
        return Collections.emptyList();
    }

    private ConfigurationBuilder createConfigurationBuilder() {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder("ITConfigSource", 110);
        configurationBuilder.with(Report.class, "properties", this.getReportProperties());
        return configurationBuilder;
    }

    @AfterEach
    public void stopStore() {
        if (this.store != null) {
            this.store.stop();
        }
    }

    private ITConfiguration createConfiguration(ConfigurationBuilder configurationBuilder) {
        return (ITConfiguration)ConfigurationMappingLoader.builder(ITConfiguration.class).withClasspath().withProfiles(this.getConfigurationProfiles()).load(new ConfigSource[]{configurationBuilder.build(), new EnvConfigSource(){}, new SysPropConfigSource(), mavenSettingsConfigSource});
    }

    private void initializeRuleSet(Configuration configuration) throws RuleException, IOException {
        File ruleDirectory = this.getRuleDirectory();
        LinkedList sources = new LinkedList();
        if (ruleDirectory.exists()) {
            sources.addAll(FileRuleSource.getRuleSources((File)ruleDirectory));
        }
        sources.addAll(pluginRepository.getRulePluginRepository().getRuleSources());
        Collection ruleParserPlugins = pluginRepository.getRulePluginRepository().getRuleParserPlugins(configuration.analyze().rule());
        RuleParser ruleParser = new RuleParser(ruleParserPlugins);
        this.ruleSet = ruleParser.parse(sources);
    }

    protected File getRuleDirectory() {
        return new File(this.getClassesDirectory(this.getClass()), "rules");
    }

    private void initializeReportPlugin(Configuration configuration) {
        ReportContextImpl reportContext = new ReportContextImpl(pluginRepository.getClassLoader(), this.store, OUTPUT_DIRECTORY);
        Map reportPlugins = pluginRepository.getAnalyzerPluginRepository().getReportPlugins(configuration.analyze().report(), (ReportContext)reportContext);
        this.reportPlugin = new InMemoryReportPlugin((ReportPlugin)new CompositeReportPlugin(reportPlugins));
    }

    protected Map<String, Object> getScannerProperties() {
        return Collections.emptyMap();
    }

    protected Map<String, Object> getReportProperties() {
        return Collections.emptyMap();
    }

    protected Map<String, Collection<RuleInterpreterPlugin>> getRuleInterpreterPlugins() {
        return pluginRepository.getAnalyzerPluginRepository().getRuleInterpreterPlugins(this.getRuleInterpreterProperties());
    }

    protected Map<String, Object> getRuleInterpreterProperties() {
        return Collections.emptyMap();
    }

    private void startStore(ITConfiguration configuration) {
        AetherArtifactProvider artifactProvider = ArtifactProviderFactory.getArtifactProvider((ArtifactResolverConfiguration)configuration, (File)USER_HOME);
        StoreFactory storeFactory = new StoreFactory(pluginRepository.getStorePluginRepository(), (ArtifactProvider)artifactProvider);
        this.store = storeFactory.getStore(configuration.store(), () -> TEST_STORE_DIRECTORY);
        this.store.start();
        if (this.isReset()) {
            this.store.reset();
        }
    }

    protected boolean isReset() {
        return true;
    }

    protected Scanner getScanner() {
        return this.getScanner(this.getScannerProperties());
    }

    protected Scanner getScanner(Map<String, Object> properties) {
        ConfigurationBuilder configurationBuilder = this.createConfigurationBuilder().with(Scan.class, "properties", properties);
        ITConfiguration configuration = this.createConfiguration(configurationBuilder);
        ScannerContextImpl scannerContext = new ScannerContextImpl(pluginRepository.getClassLoader(), this.store, WORKING_DIRECTORY, OUTPUT_DIRECTORY);
        ScannerPluginRepository scannerPluginRepository = pluginRepository.getScannerPluginRepository();
        return new ScannerImpl(configuration.scan(), (ScannerContext)scannerContext, scannerPluginRepository);
    }

    private Analyzer getAnalyzer(Map<String, String> parameters) {
        ConfigurationBuilder configurationBuilder = this.createConfigurationBuilder().with(Analyze.class, "rule-parameters", parameters);
        ITConfiguration configuration = this.createConfiguration(configurationBuilder);
        Baseline baselineConfiguration = configuration.analyze().baseline();
        BaselineRepository baselineRepository = new BaselineRepository(baselineConfiguration, this.getRuleDirectory());
        BaselineManager baselineManager = new BaselineManager(baselineConfiguration, baselineRepository);
        return new AnalyzerImpl(configuration.analyze(), pluginRepository.getClassLoader(), this.store, this.getRuleInterpreterPlugins(), baselineManager, (ReportPlugin)this.reportPlugin);
    }

    protected File getClassesDirectory(Class<?> rootClass) {
        String path = URLDecoder.decode(rootClass.getClassLoader().getResource(".").getPath(), Charset.defaultCharset());
        File directory = new File(path);
        Assertions.assertThat((File)directory).isDirectory().describedAs("Expected %s to be a directory", new Object[]{directory.toString()});
        return directory;
    }

    protected TestResult query(String query) {
        return this.query(query, Collections.emptyMap());
    }

    protected TestResult query(String query, Map<String, Object> parameters) {
        HashMap<String, List<Object>> columns;
        ArrayList<Map<String, Object>> rows;
        try (Query.Result compositeRowObjects = this.store.executeQuery(query, parameters);){
            rows = new ArrayList<Map<String, Object>>();
            columns = new HashMap<String, List<Object>>();
            for (Query.Result.CompositeRowObject rowObject : compositeRowObjects) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                List columnNames = rowObject.getColumns();
                for (String columnName : columnNames) {
                    List columnValues = columns.computeIfAbsent(columnName, k -> new ArrayList());
                    Object value = rowObject.get(columnName, Object.class);
                    row.put(columnName, value);
                    columnValues.add(value);
                }
                rows.add(row);
            }
        }
        return new TestResult(rows, columns);
    }

    protected Result<Concept> applyConcept(@ConceptId String id) throws RuleException {
        return this.applyConcept(id, Collections.emptyMap());
    }

    protected Result<Concept> applyConcept(@ConceptId String id, Map<String, String> parameters) throws RuleException {
        Analyzer analyzer = this.getAnalyzer(parameters);
        RuleSelection ruleSelection = RuleSelection.builder().conceptId(id).build();
        Concept concept = (Concept)this.ruleSet.getConceptBucket().getById(id);
        ((ObjectAssert)Assertions.assertThat((Object)concept).describedAs("The requested concept cannot be found: " + id, new Object[0])).isNotNull();
        analyzer.execute(this.ruleSet, ruleSelection);
        return (Result)this.reportPlugin.getConceptResults().get(id);
    }

    protected Result<Constraint> validateConstraint(@ConstraintId String id) throws RuleException {
        return this.validateConstraint(id, Collections.emptyMap());
    }

    protected Result<Constraint> validateConstraint(@ConstraintId String id, Map<String, String> parameters) throws RuleException {
        RuleSelection ruleSelection = RuleSelection.builder().constraintId(id).build();
        Constraint constraint = (Constraint)this.ruleSet.getConstraintBucket().getById(id);
        ((ObjectAssert)Assertions.assertThat((Object)constraint).describedAs("The requested constraint cannot be found: " + id, new Object[0])).isNotNull();
        this.getAnalyzer(parameters).execute(this.ruleSet, ruleSelection);
        return (Result)this.reportPlugin.getConstraintResults().get(id);
    }

    protected void executeGroup(@GroupId String id) throws RuleException {
        this.executeGroup(id, Collections.emptyMap());
    }

    protected void executeGroup(@GroupId String id, Map<String, String> parameters) throws RuleException {
        RuleSelection ruleSelection = RuleSelection.builder().groupId(id).build();
        Group group = (Group)this.ruleSet.getGroupsBucket().getById(id);
        ((ObjectAssert)Assertions.assertThat((Object)group).describedAs("The request group cannot be found: " + id, new Object[0])).isNotNull();
        this.getAnalyzer(parameters).execute(this.ruleSet, ruleSelection);
    }

    protected static class TestResult {
        private List<Map<String, Object>> rows;
        private Map<String, List<Object>> columns;

        public <T> List<T> getColumn(String name) {
            List<Object> column = this.columns.get(name);
            if (column == null) {
                throw new IllegalArgumentException("The result does not contain a column '" + name + "'.");
            }
            return column;
        }

        @Generated
        public List<Map<String, Object>> getRows() {
            return this.rows;
        }

        @Generated
        public Map<String, List<Object>> getColumns() {
            return this.columns;
        }

        @Generated
        private TestResult(List<Map<String, Object>> rows, Map<String, List<Object>> columns) {
            this.rows = rows;
            this.columns = columns;
        }

        @Generated
        public String toString() {
            return "AbstractPluginIT.TestResult(rows=" + String.valueOf(this.getRows()) + ", columns=" + String.valueOf(this.getColumns()) + ")";
        }
    }
}

