/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.test.plugin;

import com.buschmais.jqassistant.core.resolver.api.ArtifactProviderFactory;
import com.buschmais.jqassistant.core.resolver.api.MavenSettingsConfigSourceBuilder;
import com.buschmais.jqassistant.core.resolver.configuration.ArtifactResolverConfiguration;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.runtime.api.bootstrap.PluginRepositoryFactory;
import com.buschmais.jqassistant.core.runtime.api.bootstrap.RuleProvider;
import com.buschmais.jqassistant.core.runtime.api.configuration.Configuration;
import com.buschmais.jqassistant.core.runtime.api.plugin.PluginRepository;
import com.buschmais.jqassistant.core.shared.aether.AetherArtifactProvider;
import com.buschmais.jqassistant.core.shared.artifact.ArtifactProvider;
import com.buschmais.jqassistant.core.shared.configuration.ConfigurationMappingLoader;
import io.smallrye.config.ConfigMapping;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapIT {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BootstrapIT.class);
    public static final String DEFAULT_RULE_DIRECTORY = "jqassistant";

    @Test
    void bootstrap() throws RuleException {
        File userHome = new File(System.getProperty("user.home"));
        List configProfiles = Collections.emptyList();
        ConfigSource settingsConfigSource = MavenSettingsConfigSourceBuilder.createMavenSettingsConfigSource((File)userHome, Optional.empty(), configProfiles);
        List configLocations = Collections.emptyList();
        File workingDirectory = new File(".");
        ITConfiguration configuration = (ITConfiguration)ConfigurationMappingLoader.builder(ITConfiguration.class, configLocations).withUserHome(userHome).withWorkingDirectory(workingDirectory).withClasspath().withEnvVariables().withProfiles(configProfiles).load(new ConfigSource[]{settingsConfigSource});
        AetherArtifactProvider artifactProvider = ArtifactProviderFactory.getArtifactProvider((ArtifactResolverConfiguration)configuration, (File)userHome);
        PluginRepository pluginRepository = PluginRepositoryFactory.getPluginRepository((Configuration)configuration, (ClassLoader)BootstrapIT.class.getClassLoader(), (ArtifactProvider)artifactProvider);
        RuleProvider ruleProvider = RuleProvider.create((Configuration)configuration, (String)DEFAULT_RULE_DIRECTORY, (PluginRepository)pluginRepository);
        log.info("Rule sources: {}.", (Object)ruleProvider.getRuleSources());
        log.info("Available rules: {}.", (Object)ruleProvider.getAvailableRules());
        log.info("Effective rules (Groups): {}.", (Object)ruleProvider.getEffectiveRules().getGroups());
        log.info("Effective rules (Concepts): {}.", (Object)ruleProvider.getEffectiveRules().getConcepts());
        log.info("Effective rules (Constraints): {}.", (Object)ruleProvider.getEffectiveRules().getConstraints());
    }

    @ConfigMapping(prefix="jqassistant")
    static interface ITConfiguration
    extends Configuration,
    ArtifactResolverConfiguration {
    }
}

