/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public final class ProjectResolver {
    public static final String DEFAULT_RULES_DIRECTORY = "jqassistant";
    public static final String OUTPUT_DIRECTORY = "jqassistant";

    private ProjectResolver() {
    }

    static MavenProject getRootModule(MavenProject module, List<MavenProject> reactor, String rulesDirectory, boolean useExecutionRootAsProjectRoot) throws MojoExecutionException {
        String rootModuleContextKey = ProjectResolver.class.getName() + "#rootModule";
        MavenProject rootModule = (MavenProject)module.getContextValue(rootModuleContextKey);
        if (rootModule == null) {
            rootModule = useExecutionRootAsProjectRoot ? ProjectResolver.getRootModule(reactor) : ProjectResolver.getRootModule(module, rulesDirectory);
            module.setContextValue(rootModuleContextKey, (Object)rootModule);
        }
        return rootModule;
    }

    private static MavenProject getRootModule(List<MavenProject> reactor) throws MojoExecutionException {
        for (MavenProject mavenProject : reactor) {
            if (!mavenProject.isExecutionRoot()) continue;
            return mavenProject;
        }
        throw new MojoExecutionException("Cannot determine execution root.");
    }

    private static MavenProject getRootModule(MavenProject module, String rulesDirectory) throws MojoExecutionException {
        MavenProject parent;
        File directory = ProjectResolver.getRulesDirectory(module, rulesDirectory);
        MavenProject rootModule = directory.exists() && directory.isDirectory() ? module : ((parent = module.getParent()) != null && parent.getBasedir() != null ? ProjectResolver.getRootModule(parent, rulesDirectory) : module);
        return rootModule;
    }

    static Map<MavenProject, List<MavenProject>> getProjects(List<MavenProject> reactorProjects, String rulesDirectory, boolean useExecutionRootAsProjectRoot) throws MojoExecutionException {
        HashMap<MavenProject, List<MavenProject>> rootModules = new HashMap<MavenProject, List<MavenProject>>();
        for (MavenProject reactorProject : reactorProjects) {
            MavenProject rootModule = ProjectResolver.getRootModule(reactorProject, reactorProjects, rulesDirectory, useExecutionRootAsProjectRoot);
            ArrayList<MavenProject> modules = (ArrayList<MavenProject>)rootModules.get(rootModule);
            if (modules == null) {
                modules = new ArrayList<MavenProject>();
                rootModules.put(rootModule, modules);
            }
            modules.add(reactorProject);
        }
        return rootModules;
    }

    static boolean containsBuildPlugin(MavenProject project, Plugin plugin) {
        return project.getBuildPlugins().contains(plugin);
    }

    static File getRulesDirectory(MavenProject rootModule, String rulesDirectory) {
        File rules = new File(rulesDirectory);
        return rules.isAbsolute() ? rules : new File(rootModule.getBasedir().getAbsolutePath() + File.separator + rulesDirectory);
    }

    static File getOutputDirectory(MavenProject rootModule) {
        String directoryName = rootModule.getBuild().getDirectory() + "/" + "jqassistant";
        File directory = new File(directoryName);
        directory.mkdirs();
        return directory;
    }

    static File getOutputFile(MavenProject rootModule, File reportFile, String defaultFile) throws MojoExecutionException {
        File selectedXmlReportFile;
        if (reportFile != null) {
            selectedXmlReportFile = reportFile;
        } else if (rootModule != null) {
            selectedXmlReportFile = new File(ProjectResolver.getOutputDirectory(rootModule) + "/" + defaultFile);
        } else {
            throw new MojoExecutionException("Cannot determine report file.");
        }
        return selectedXmlReportFile;
    }
}

