/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.configuration.api.ConfigurationBuilder;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.scanner.api.configuration.Include;
import com.buschmais.jqassistant.core.scanner.api.configuration.Scan;
import com.buschmais.jqassistant.core.scanner.impl.ScannerContextImpl;
import com.buschmais.jqassistant.core.scanner.impl.ScannerImpl;
import com.buschmais.jqassistant.core.scanner.spi.ScannerPluginRepository;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.plugin.common.api.scanner.FileResolver;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.ArtifactResolver;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.MavenRepositoryArtifactResolver;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.MavenScope;
import com.buschmais.jqassistant.scm.maven.AbstractModuleMojo;
import com.buschmais.jqassistant.scm.maven.MojoExecutionContext;
import com.buschmais.jqassistant.scm.maven.configuration.MavenConfiguration;
import com.buschmais.jqassistant.scm.maven.configuration.mojo.ScanInclude;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;

@Mojo(name="scan", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true, configurator="custom")
public class ScanMojo
extends AbstractModuleMojo {
    @Parameter(property="jqassistant.scan.includes")
    protected List<ScanInclude> scanIncludes;
    @Parameter(property="jqassistant.scan.properties")
    private Map<String, Object> scanProperties;
    @Parameter(property="jqassistant.scan.continueOnError")
    private boolean continueOnError = false;
    @Parameter(property="jqassistant.store.reset")
    protected boolean reset = true;
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;

    @Override
    protected boolean isResetStoreBeforeExecution() {
        return this.reset;
    }

    @Override
    protected boolean isConnectorRequired() {
        return false;
    }

    @Override
    protected void configure(ConfigurationBuilder configurationBuilder) throws MojoExecutionException {
        super.configure(configurationBuilder);
        configurationBuilder.with(Scan.class, "continue-on-error", this.continueOnError).with(Scan.class, "reset", this.reset).with(Scan.class, "properties", this.scanProperties);
        ArrayList<String> files = new ArrayList<String>();
        ArrayList<String> urls = new ArrayList<String>();
        for (ScanInclude scanInclude : this.scanIncludes) {
            String path = scanInclude.getPath();
            URL url = scanInclude.getUrl();
            String scope = scanInclude.getScope();
            StringBuilder builder = new StringBuilder();
            if (scope != null) {
                builder.append(scope).append("::");
            }
            if (path != null) {
                files.add(builder.append(path).toString());
                continue;
            }
            if (url != null) {
                urls.add(builder.append(url).toString());
                continue;
            }
            throw new MojoExecutionException("A scanInclude can only include either a file or an URL: path=" + scanInclude.getPath() + ", url=" + scanInclude.getUrl());
        }
        configurationBuilder.with(Include.class, "files", files);
        configurationBuilder.with(Include.class, "urls", urls);
    }

    @Override
    public void execute(MojoExecutionContext mojoExecutionContext, MavenProject mavenProject) throws MojoExecutionException, MojoFailureException {
        MavenConfiguration configuration = mojoExecutionContext.getConfiguration();
        File outputDirectory = mojoExecutionContext.getOutputDirectory();
        this.withStore(store -> this.scan(mavenProject, configuration, store, outputDirectory), mojoExecutionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(MavenProject mavenProject, MavenConfiguration configuration, Store store, File outputDirectory) {
        ScannerPluginRepository scannerPluginRepository = this.getPluginRepository(configuration).getScannerPluginRepository();
        ScannerContextImpl scannerContext = new ScannerContextImpl(store, outputDirectory);
        ScannerImpl scanner = new ScannerImpl(configuration.scan(), (ScannerContext)scannerContext, scannerPluginRepository);
        File localRepositoryDirectory = this.session.getProjectBuildingRequest().getRepositorySession().getLocalRepository().getBasedir();
        FileResolver fileResolver = (FileResolver)scannerContext.peek(FileResolver.class);
        MavenRepositoryArtifactResolver repositoryArtifactResolver = new MavenRepositoryArtifactResolver(localRepositoryDirectory, fileResolver);
        scannerContext.push(MavenSession.class, (Object)this.session);
        scannerContext.push(ArtifactResolver.class, (Object)repositoryArtifactResolver);
        scannerContext.push(DependencyGraphBuilder.class, (Object)this.dependencyGraphBuilder);
        try {
            scanner.scan((Object)mavenProject, mavenProject.getFile().getAbsolutePath(), (Scope)MavenScope.PROJECT);
        }
        finally {
            scannerContext.pop(DependencyGraphBuilder.class);
            scannerContext.pop(ArtifactResolver.class);
            scannerContext.pop(MavenSession.class);
        }
    }
}

