/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.configuration.api.ConfigurationBuilder;
import com.buschmais.jqassistant.core.plugin.api.PluginRepository;
import com.buschmais.jqassistant.core.rule.api.configuration.Rule;
import com.buschmais.jqassistant.core.shared.option.OptionHelper;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.configuration.Remote;
import com.buschmais.jqassistant.neo4j.backend.bootstrap.configuration.Embedded;
import com.buschmais.jqassistant.scm.maven.AbstractProjectMojo;
import com.buschmais.jqassistant.scm.maven.MojoExecutionContext;
import com.buschmais.jqassistant.scm.maven.StoreLifecycle;
import com.buschmais.jqassistant.scm.maven.configuration.Maven;
import com.buschmais.jqassistant.scm.maven.configuration.MavenConfiguration;
import com.buschmais.jqassistant.scm.maven.configuration.mojo.EmbeddedNeo4jConfiguration;
import com.buschmais.jqassistant.scm.maven.configuration.mojo.StoreConfiguration;
import com.buschmais.jqassistant.scm.maven.configuration.source.MavenProjectConfigSource;
import com.buschmais.jqassistant.scm.maven.configuration.source.SettingsConfigSource;
import com.buschmais.jqassistant.scm.maven.provider.CachingStoreProvider;
import com.buschmais.jqassistant.scm.maven.provider.ConfigurationProvider;
import com.buschmais.jqassistant.scm.maven.provider.PluginRepositoryProvider;
import io.smallrye.config.PropertiesConfigSource;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.microprofile.config.spi.ConfigSource;

public abstract class AbstractMojo
extends org.apache.maven.plugin.AbstractMojo {
    public static final String PARAMETER_EMBEDDED_LISTEN_ADDRESS = "jqassistant.embedded.listenAddress";
    public static final String PARAMETER_EMBEDDED_BOLT_PORT = "jqassistant.embedded.boltPort";
    public static final String PARAMETER_EMBEDDED_HTTP_PORT = "jqassistant.embedded.httpPort";
    public static final String STORE_DIRECTORY = "jqassistant/store";
    public static final String PROPERTY_STORE_LIFECYCLE = "jqassistant.store.lifecycle";
    @Parameter(property="jqassistant.configuration.locations")
    private List<String> configurationLocations;
    @Parameter(property="jqassistant.store.directory")
    private File storeDirectory;
    @Parameter(property="jqassistant.store.uri")
    private URI storeUri;
    @Parameter(property="jqassistant.store.username")
    private String storeUserName;
    @Parameter(property="jqassistant.store.password")
    private String storePassword;
    @Parameter(property="jqassistant.store.encryption")
    private String storeEncryption;
    @Parameter(property="jqassistant.store.trustStrategy")
    private String storeTrustStrategy;
    @Parameter(property="jqassistant.store.trustCertificate")
    private String storeTrustCertificate;
    @Parameter
    private StoreConfiguration store = new StoreConfiguration();
    @Parameter(property="jqassistant.embedded.listenAddress")
    private String embeddedListenAddress;
    @Parameter(property="jqassistant.embedded.boltPort")
    private Integer embeddedBoltPort;
    @Parameter(property="jqassistant.embedded.httpPort")
    private Integer embeddedHttpPort;
    @Parameter(property="jqassistant.useExecutionRootAsProjectRoot")
    protected boolean useExecutionRootAsProjectRoot = false;
    @Parameter(property="jqassistant.rules.directory", defaultValue="jqassistant")
    private String rulesDirectory;
    @Parameter(property="jqassistant.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="jqassistant.store.lifecycle")
    protected StoreLifecycle storeLifecycle = StoreLifecycle.REACTOR;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(property="project")
    protected MavenProject currentProject;
    @Parameter(property="mojoExecution")
    protected MojoExecution execution;
    @Component
    private RuntimeInformation runtimeInformation;
    @Component
    private ConfigurationProvider configurationProvider;
    @Component
    private PluginRepositoryProvider pluginRepositoryProvider;
    @Component
    private CachingStoreProvider cachingStoreProvider;
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repositories;

    private static String createExecutionKey(MojoExecution mojoExecution) {
        return mojoExecution.getGoal() + "@" + mojoExecution.getExecutionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.runtimeInformation.isMavenVersion("[3.5,)")) {
            throw new MojoExecutionException("jQAssistant requires Maven 3.5.x or above.");
        }
        Class<AbstractMojo> clazz = AbstractMojo.class;
        synchronized (AbstractMojo.class) {
            MavenConfiguration configuration = this.getConfiguration();
            MojoExecutionContext mojoExecutionContext = new MojoExecutionContext(this.session, this.currentProject, configuration);
            MavenProject rootModule = mojoExecutionContext.getRootModule();
            Set<MavenProject> executedModules = this.getExecutedModules(rootModule);
            if (configuration.skip()) {
                this.getLog().info((CharSequence)"Skipping execution.");
            } else {
                if (this.isResetStoreBeforeExecution() && executedModules.isEmpty()) {
                    this.withStore(store -> store.reset(), mojoExecutionContext);
                }
                this.execute(mojoExecutionContext, executedModules);
            }
            executedModules.add(this.currentProject);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected abstract void execute(MojoExecutionContext var1, Set<MavenProject> var2) throws MojoExecutionException, MojoFailureException;

    protected abstract boolean isResetStoreBeforeExecution();

    protected abstract boolean isConnectorRequired();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void withStore(StoreOperation storeOperation, MojoExecutionContext mojoExecutionContext) throws MojoExecutionException, MojoFailureException {
        MavenProject rootModule = mojoExecutionContext.getRootModule();
        MavenConfiguration configuration = mojoExecutionContext.getConfiguration();
        Store store = this.getStore(configuration, () -> this.storeDirectory != null ? this.storeDirectory : new File(rootModule.getBuild().getDirectory(), STORE_DIRECTORY));
        try {
            storeOperation.run(store);
        }
        finally {
            this.releaseStore(store);
        }
    }

    private Set<MavenProject> getExecutedModules(MavenProject rootModule) {
        HashSet executedProjects;
        String executionKey = AbstractMojo.createExecutionKey(this.execution);
        String executedModulesContextKey = AbstractProjectMojo.class.getName() + "#executedModules";
        HashMap executedProjectsPerExecutionKey = (HashMap)rootModule.getContextValue(executedModulesContextKey);
        if (executedProjectsPerExecutionKey == null) {
            executedProjectsPerExecutionKey = new HashMap();
            rootModule.setContextValue(executedModulesContextKey, executedProjectsPerExecutionKey);
        }
        if ((executedProjects = (HashSet)executedProjectsPerExecutionKey.get(executionKey)) == null) {
            executedProjects = new HashSet();
            executedProjectsPerExecutionKey.put(executionKey, executedProjects);
        }
        return executedProjects;
    }

    private Store getStore(MavenConfiguration configuration, Supplier<File> storeDirectorySupplier) throws MojoExecutionException {
        Store existingStore = this.cachingStoreProvider.getStore(configuration.store(), storeDirectorySupplier, this.getPluginRepository(configuration));
        if (!Store.class.isAssignableFrom(existingStore.getClass())) {
            throw new MojoExecutionException("Cannot re-use store instance from reactor. Either declare the plugin as extension or execute Maven using the property -Djqassistant.store.lifecycle=" + (Object)((Object)StoreLifecycle.MODULE) + " on the command line.");
        }
        return existingStore;
    }

    private void releaseStore(Store store) {
        switch (this.storeLifecycle) {
            case MODULE: {
                this.cachingStoreProvider.closeStore(store);
                break;
            }
        }
    }

    private MavenConfiguration getConfiguration() throws MojoExecutionException {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder("MojoConfigSource", 110);
        this.addStoreConfiguration(configurationBuilder);
        this.configure(configurationBuilder);
        File executionRoot = new File(this.session.getExecutionRootDirectory());
        MavenProjectConfigSource projectConfigSource = new MavenProjectConfigSource(this.currentProject);
        SettingsConfigSource settingsConfigSource = new SettingsConfigSource(this.session.getSettings());
        PropertiesConfigSource projectPropertiesConfigSource = new PropertiesConfigSource(this.currentProject.getProperties(), "Maven Project Properties");
        PropertiesConfigSource userPropertiesConfigSource = new PropertiesConfigSource(this.session.getUserProperties(), "Maven Session User Properties ");
        PropertiesConfigSource systemPropertiesConfigSource = new PropertiesConfigSource(this.session.getSystemProperties(), "Maven Session System Properties");
        return this.configurationProvider.getConfiguration(executionRoot, CollectionUtils.isEmpty(this.configurationLocations) ? Optional.empty() : Optional.of(this.configurationLocations), new ConfigSource[]{configurationBuilder.build(), projectConfigSource, settingsConfigSource, projectPropertiesConfigSource, userPropertiesConfigSource, systemPropertiesConfigSource});
    }

    private void addStoreConfiguration(ConfigurationBuilder configurationBuilder) {
        configurationBuilder.with(com.buschmais.jqassistant.core.store.api.configuration.Store.class, "uri", (URI)OptionHelper.coalesce((Object[])new URI[]{this.storeUri, this.store.getUri()}));
        configurationBuilder.with(Remote.class, "username", (String)OptionHelper.coalesce((Object[])new String[]{this.storeUserName, this.store.getUsername()}));
        configurationBuilder.with(Remote.class, "password", (String)OptionHelper.coalesce((Object[])new String[]{this.storePassword, this.store.getPassword()}));
        configurationBuilder.with(Remote.class, "encryption", (String)OptionHelper.coalesce((Object[])new String[]{this.storeEncryption, this.store.getEncryption()}));
        configurationBuilder.with(Remote.class, "trust-strategy", (String)OptionHelper.coalesce((Object[])new String[]{this.storeTrustStrategy, this.store.getTrustStrategy()}));
        configurationBuilder.with(Remote.class, "trust-certificate", (String)OptionHelper.coalesce((Object[])new String[]{this.storeTrustCertificate, this.store.getTrustCertificate()}));
        configurationBuilder.with(Remote.class, "properties", this.store.getProperties());
        EmbeddedNeo4jConfiguration embedded = this.store.getEmbedded();
        configurationBuilder.with(Embedded.class, "connector-enabled", ((Boolean)OptionHelper.coalesce((Object[])new Boolean[]{this.isConnectorRequired(), embedded.getConnectorEnabled()})).booleanValue());
        configurationBuilder.with(Embedded.class, "listen-address", (String)OptionHelper.coalesce((Object[])new String[]{this.embeddedListenAddress, embedded.getListenAddress()}));
        configurationBuilder.with(Embedded.class, "bolt-port", (Integer)OptionHelper.coalesce((Object[])new Integer[]{this.embeddedBoltPort, embedded.getBoltPort()}));
        configurationBuilder.with(Embedded.class, "http-port", (Integer)OptionHelper.coalesce((Object[])new Integer[]{this.embeddedHttpPort, embedded.getHttpPort()}));
    }

    protected void configure(ConfigurationBuilder configurationBuilder) throws MojoExecutionException {
        configurationBuilder.with(MavenConfiguration.class, "skip", this.skip);
        configurationBuilder.with(Maven.class, "use-execution-root-as-project-root", this.useExecutionRootAsProjectRoot);
        configurationBuilder.with(Rule.class, "directory", this.rulesDirectory);
    }

    protected PluginRepository getPluginRepository(MavenConfiguration configuration) {
        return this.pluginRepositoryProvider.getPluginRepository(this.repositorySystem, this.repositorySystemSession, this.repositories, configuration.plugins());
    }

    protected static interface StoreOperation {
        public void run(Store var1) throws MojoExecutionException, MojoFailureException;
    }
}

