/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.scm.maven.AbstractProjectMojo;
import com.buschmais.jqassistant.scm.maven.MojoExecutionContext;
import com.buschmais.xo.neo4j.embedded.api.EmbeddedNeo4jDatastoreSession;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.neo4j.cypher.export.DatabaseSubGraph;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.cypher.export.SubGraphExporter;
import org.neo4j.graphdb.GraphDatabaseService;

@Mojo(name="export-database", threadSafe=true, configurator="custom")
public class ExportDatabaseMojo
extends AbstractProjectMojo {
    private static final String EXPORT_FILE = "jqassistant.cypher";
    @Parameter(property="jqassistant.export.file")
    protected File exportFile;

    @Override
    protected boolean isResetStoreBeforeExecution() {
        return false;
    }

    @Override
    protected boolean isConnectorRequired() {
        return false;
    }

    @Override
    protected void aggregate(MojoExecutionContext mojoExecutionContext) throws MojoExecutionException, MojoFailureException {
        this.withStore(store -> this.export(store, mojoExecutionContext.getOutputFile(this.exportFile, EXPORT_FILE)), mojoExecutionContext);
    }

    private void export(Store store, File file) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Exporting database to '" + file.getAbsolutePath() + "'"));
        store.beginTransaction();
        try {
            GraphDatabaseService graphDatabaseService = ((EmbeddedNeo4jDatastoreSession)store.getXOManager().getDatastoreSession(EmbeddedNeo4jDatastoreSession.class)).getGraphDatabaseService();
            SubGraph graph = DatabaseSubGraph.from((GraphDatabaseService)graphDatabaseService);
            new SubGraphExporter(graph).export(new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot export database.", (Exception)e);
        }
        finally {
            store.commitTransaction();
        }
    }
}

