/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.plugin.api.PluginRepository;
import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.core.plugin.api.ScannerPluginRepository;
import com.buschmais.jqassistant.core.plugin.api.ScopePluginRepository;
import com.buschmais.jqassistant.core.scanner.api.ScannerConfiguration;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.scanner.impl.ScannerContextImpl;
import com.buschmais.jqassistant.core.scanner.impl.ScannerImpl;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.MavenScope;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.ScanInclude;
import com.buschmais.jqassistant.scm.maven.AbstractModuleMojo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;

@Mojo(name="scan", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST, threadSafe=true, configurator="custom")
public class ScanMojo
extends AbstractModuleMojo {
    @Parameter(property="jqassistant.scan.includes")
    protected List<ScanInclude> scanIncludes;
    @Parameter(property="jqassistant.scan.properties")
    private Map<String, Object> scanProperties;
    @Parameter(property="jqassistant.scan.continueOnError")
    private boolean continueOnError = false;
    @Parameter(property="jqassistant.store.reset")
    protected boolean reset = true;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;

    @Override
    protected boolean isResetStoreBeforeExecution() {
        return this.reset;
    }

    @Override
    protected boolean isConnectorRequired() {
        return false;
    }

    protected Map<String, Object> getPluginProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.scanProperties != null) {
            properties.putAll(this.scanProperties);
        }
        properties.put(ScanInclude.class.getName(), this.scanIncludes);
        return properties;
    }

    @Override
    public void execute(MavenProject mavenProject, Store store) throws MojoExecutionException {
        ScannerConfiguration configuration = new ScannerConfiguration();
        configuration.setContinueOnError(this.continueOnError);
        ScannerContextImpl scannerContext = new ScannerContextImpl(store);
        scannerContext.push(MavenSession.class, (Object)this.session);
        scannerContext.push(DependencyGraphBuilder.class, (Object)this.dependencyGraphBuilder);
        PluginRepository pluginRepository = this.pluginRepositoryProvider.getPluginRepository();
        Map<String, ScannerPlugin<?, ?>> scannerPlugins = this.getStringScannerPlugins(pluginRepository, (ScannerContext)scannerContext);
        ScopePluginRepository scopePluginRepository = pluginRepository.getScopePluginRepository();
        ScannerImpl scanner = new ScannerImpl(configuration, (ScannerContext)scannerContext, scannerPlugins, scopePluginRepository.getScopes());
        scanner.scan((Object)mavenProject, mavenProject.getFile().getAbsolutePath(), (Scope)MavenScope.PROJECT);
        scannerContext.pop(DependencyGraphBuilder.class);
        scannerContext.pop(MavenSession.class);
    }

    private Map<String, ScannerPlugin<?, ?>> getStringScannerPlugins(PluginRepository pluginRepository, ScannerContext scannerContext) throws MojoExecutionException {
        Map scannerPlugins;
        ScannerPluginRepository scannerPluginRepository = pluginRepository.getScannerPluginRepository();
        try {
            scannerPlugins = scannerPluginRepository.getScannerPlugins(scannerContext, this.getPluginProperties());
        }
        catch (PluginRepositoryException e) {
            throw new MojoExecutionException("Cannot determine scanner plugins.", (Exception)((Object)e));
        }
        return scannerPlugins;
    }
}

