/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.runtime.api.plugin.PluginRepository;
import com.buschmais.jqassistant.core.scanner.api.DefaultScope;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.scanner.impl.ScannerContextImpl;
import com.buschmais.jqassistant.core.scanner.impl.ScannerImpl;
import com.buschmais.jqassistant.core.scanner.spi.ScannerPluginRepository;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.scm.maven.AbstractModuleMojo;
import com.buschmais.jqassistant.scm.maven.MojoExecutionContext;
import com.buschmais.jqassistant.scm.maven.configuration.MavenConfiguration;
import java.io.File;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;

@Mojo(name="scan", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class ScanMojo
extends AbstractModuleMojo {
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;

    @Override
    protected boolean isResetStoreBeforeExecution() {
        return true;
    }

    @Override
    protected boolean isConnectorRequired() {
        return false;
    }

    @Override
    public void execute(MojoExecutionContext mojoExecutionContext, MavenProject mavenProject) throws MojoExecutionException, MojoFailureException {
        MavenConfiguration configuration = mojoExecutionContext.getConfiguration();
        File outputDirectory = mojoExecutionContext.getOutputDirectory();
        this.withStore(store -> this.scan(mavenProject, configuration, store, outputDirectory), mojoExecutionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(MavenProject mavenProject, MavenConfiguration configuration, Store store, File outputDirectory) {
        PluginRepository pluginRepository = this.getPluginRepository(configuration);
        ScannerPluginRepository scannerPluginRepository = pluginRepository.getScannerPluginRepository();
        ScannerContextImpl scannerContext = new ScannerContextImpl(pluginRepository.getClassLoader(), store, outputDirectory);
        ScannerImpl scanner = new ScannerImpl(configuration.scan(), (ScannerContext)scannerContext, scannerPluginRepository);
        scannerContext.push(MavenSession.class, (Object)this.session);
        scannerContext.push(DependencyGraphBuilder.class, (Object)this.dependencyGraphBuilder);
        try {
            scanner.scan((Object)mavenProject, mavenProject.getFile().getAbsolutePath(), (Scope)DefaultScope.NONE);
        }
        finally {
            scannerContext.pop(DependencyGraphBuilder.class);
            scannerContext.pop(MavenSession.class);
        }
    }
}

