/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.runtime.api.plugin.PluginRepository;
import com.buschmais.jqassistant.scm.maven.configuration.MavenConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public final class MojoExecutionContext {
    public static final String DEFAULT_RULES_DIRECTORY = "jqassistant";
    public static final String OUTPUT_DIRECTORY = "jqassistant";
    private final MavenSession mavenSession;
    private final MavenProject currentModule;
    private final MavenProject rootModule;
    private final MojoExecution mojoExecution;
    private final MavenConfiguration configuration;
    private final PluginRepository pluginRepository;

    MojoExecutionContext(MavenSession session, MavenProject currentModule, MojoExecution mojoExecution, MavenConfiguration configuration, PluginRepository pluginRepository) throws MojoExecutionException {
        this.mavenSession = session;
        this.currentModule = currentModule;
        this.mojoExecution = mojoExecution;
        this.configuration = configuration;
        this.pluginRepository = pluginRepository;
        this.rootModule = this.getRootModule(currentModule, session.getProjects());
    }

    private MavenProject getRootModule(MavenProject module, List<MavenProject> reactor) throws MojoExecutionException {
        String rootModuleContextKey = MojoExecutionContext.class.getName() + "#rootModule";
        MavenProject rootModule = (MavenProject)module.getContextValue(rootModuleContextKey);
        if (rootModule == null) {
            rootModule = this.configuration.maven().useExecutionRootAsProjectRoot() ? this.getRootModule(reactor) : this.getRootModule(module);
            module.setContextValue(rootModuleContextKey, (Object)rootModule);
        }
        return rootModule;
    }

    private MavenProject getRootModule(List<MavenProject> reactor) throws MojoExecutionException {
        for (MavenProject mavenProject : reactor) {
            if (!mavenProject.isExecutionRoot()) continue;
            return mavenProject;
        }
        throw new MojoExecutionException("Cannot determine execution root.");
    }

    private MavenProject getRootModule(MavenProject module) {
        File directory = this.getDirectory(module, this.getRuleDirectoryName());
        if (directory.exists() && directory.isDirectory()) {
            return module;
        }
        MavenProject parent = module.getParent();
        if (parent != null && parent.getBasedir() != null) {
            return this.getRootModule(parent);
        }
        return module;
    }

    Map<MavenProject, List<MavenProject>> getProjects() throws MojoExecutionException {
        HashMap<MavenProject, List<MavenProject>> rootModules = new HashMap<MavenProject, List<MavenProject>>();
        for (MavenProject reactorProject : this.mavenSession.getProjects()) {
            MavenProject rootModule = this.getRootModule(reactorProject, this.mavenSession.getProjects());
            rootModules.computeIfAbsent(rootModule, module -> new ArrayList()).add(reactorProject);
        }
        return rootModules;
    }

    File getRuleDirectory() {
        String directoryName = this.getRuleDirectoryName();
        return this.getRuleDirectory(directoryName);
    }

    File getRuleDirectory(String directoryName) {
        return this.getDirectory(this.rootModule, directoryName);
    }

    private File getDirectory(MavenProject module, String directoryName) {
        File directory = new File(directoryName);
        return directory.isAbsolute() ? directory : new File(module.getBasedir(), directoryName);
    }

    private String getRuleDirectoryName() {
        return this.configuration.analyze().rule().directory().orElse("jqassistant");
    }

    boolean containsBuildPlugin(MavenProject project, Plugin plugin) {
        return project.getBuildPlugins().contains(plugin);
    }

    File getOutputDirectory() {
        String directoryName = this.rootModule.getBuild().getDirectory() + "/jqassistant";
        File directory = new File(directoryName);
        directory.mkdirs();
        return directory;
    }

    File getOutputFile(File reportFile, String defaultFile) throws MojoExecutionException {
        File selectedXmlReportFile;
        if (reportFile != null) {
            selectedXmlReportFile = reportFile;
        } else if (this.rootModule != null) {
            selectedXmlReportFile = new File(this.getOutputDirectory() + "/" + defaultFile);
        } else {
            throw new MojoExecutionException("Cannot determine report file.");
        }
        return selectedXmlReportFile;
    }

    public MavenSession getMavenSession() {
        return this.mavenSession;
    }

    public MavenProject getCurrentModule() {
        return this.currentModule;
    }

    public MavenProject getRootModule() {
        return this.rootModule;
    }

    public MojoExecution getMojoExecution() {
        return this.mojoExecution;
    }

    public MavenConfiguration getConfiguration() {
        return this.configuration;
    }

    public PluginRepository getPluginRepository() {
        return this.pluginRepository;
    }
}

