/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven.provider;

import com.buschmais.jqassistant.core.runtime.api.plugin.PluginRepository;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.StoreFactory;
import com.buschmais.jqassistant.core.store.spi.StorePluginRepository;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=CachingStoreProvider.class, instantiationStrategy="singleton")
public class CachingStoreProvider
implements Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingStoreProvider.class);
    private Map<StoreKey, Store> storesByKey = new HashMap<StoreKey, Store>();
    private Map<Store, StoreKey> keysByStore = new IdentityHashMap<Store, StoreKey>();

    public Store getStore(com.buschmais.jqassistant.core.store.api.configuration.Store storeConfiguration, Supplier<File> storeDirectorySupplier, PluginRepository pluginRepository) {
        URI uri = storeConfiguration.uri().orElseGet(() -> {
            File storeDirectory = (File)storeDirectorySupplier.get();
            storeDirectory.mkdirs();
            return storeDirectory.toURI();
        }).normalize();
        StoreKey.StoreKeyBuilder storeKeyBuilder = StoreKey.builder().uri(uri);
        storeConfiguration.remote().username().ifPresent(username -> storeKeyBuilder.username((String)username));
        StoreKey key = storeKeyBuilder.build();
        Store store = this.storesByKey.get(key);
        if (store == null) {
            store = StoreFactory.getStore((com.buschmais.jqassistant.core.store.api.configuration.Store)storeConfiguration, storeDirectorySupplier, (StorePluginRepository)pluginRepository.getStorePluginRepository());
            store.start();
            this.storesByKey.put(key, store);
            this.keysByStore.put(store, key);
        }
        return store;
    }

    public void closeStore(Store store) {
        this.close(store);
        StoreKey key = this.keysByStore.remove(store);
        this.storesByKey.remove(key);
    }

    public void dispose() {
        for (Store store : this.storesByKey.values()) {
            this.close(store);
        }
        this.storesByKey.clear();
        this.keysByStore.clear();
    }

    private void close(Store store) {
        StoreKey key = this.keysByStore.get(store);
        LOGGER.info("Closing connection to store '{}'.", (Object)key.getUri());
        store.stop();
    }

    private static class StoreKey {
        private final URI uri;
        private final String username;

        StoreKey(URI uri, String username) {
            this.uri = uri;
            this.username = username;
        }

        public static StoreKeyBuilder builder() {
            return new StoreKeyBuilder();
        }

        public URI getUri() {
            return this.uri;
        }

        public String getUsername() {
            return this.username;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StoreKey)) {
                return false;
            }
            StoreKey other = (StoreKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            URI this$uri = this.getUri();
            URI other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            return !(this$username == null ? other$username != null : !this$username.equals(other$username));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StoreKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            URI $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            return result;
        }

        public String toString() {
            return "CachingStoreProvider.StoreKey(uri=" + this.getUri() + ", username=" + this.getUsername() + ")";
        }

        public static class StoreKeyBuilder {
            private URI uri;
            private String username;

            StoreKeyBuilder() {
            }

            public StoreKeyBuilder uri(URI uri) {
                this.uri = uri;
                return this;
            }

            public StoreKeyBuilder username(String username) {
                this.username = username;
                return this;
            }

            public StoreKey build() {
                return new StoreKey(this.uri, this.username);
            }

            public String toString() {
                return "CachingStoreProvider.StoreKey.StoreKeyBuilder(uri=" + this.uri + ", username=" + this.username + ")";
            }
        }
    }
}

