/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.runtime.api.configuration.ConfigurationBuilder;
import com.buschmais.jqassistant.core.runtime.api.configuration.ConfigurationMappingLoader;
import com.buschmais.jqassistant.core.runtime.api.plugin.PluginRepository;
import com.buschmais.jqassistant.core.runtime.impl.plugin.AetherArtifactProvider;
import com.buschmais.jqassistant.core.shared.artifact.ArtifactProvider;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.configuration.Embedded;
import com.buschmais.jqassistant.scm.maven.AbstractProjectMojo;
import com.buschmais.jqassistant.scm.maven.MojoExecutionContext;
import com.buschmais.jqassistant.scm.maven.configuration.Maven;
import com.buschmais.jqassistant.scm.maven.configuration.MavenConfiguration;
import com.buschmais.jqassistant.scm.maven.configuration.source.EmptyConfigSource;
import com.buschmais.jqassistant.scm.maven.configuration.source.MavenProjectConfigSource;
import com.buschmais.jqassistant.scm.maven.configuration.source.MavenPropertiesConfigSource;
import com.buschmais.jqassistant.scm.maven.configuration.source.SettingsConfigSource;
import com.buschmais.jqassistant.scm.maven.provider.CachingStoreProvider;
import com.buschmais.jqassistant.scm.maven.provider.PluginRepositoryProvider;
import io.smallrye.config.source.yaml.YamlConfigSource;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.microprofile.config.spi.ConfigSource;

public abstract class AbstractMojo
extends org.apache.maven.plugin.AbstractMojo {
    public static final String STORE_DIRECTORY = "jqassistant/store";
    private static final int CONFIGURATION_ORDINAL_EXECUTION_ROOT = 90;
    @Parameter(property="jqassistant.configuration.locations")
    private List<String> configurationLocations;
    @Parameter
    private String yaml;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(property="project")
    private MavenProject currentProject;
    @Parameter(property="mojoExecution")
    private MojoExecution execution;
    @Component
    private RuntimeInformation runtimeInformation;
    @Component
    private PluginRepositoryProvider pluginRepositoryProvider;
    @Component
    private CachingStoreProvider cachingStoreProvider;
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repositories;

    private static String createExecutionKey(MojoExecution mojoExecution) {
        return mojoExecution.getGoal() + "@" + mojoExecution.getExecutionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.runtimeInformation.isMavenVersion("[3.5,)")) {
            throw new MojoExecutionException("jQAssistant requires Maven 3.5.x or above.");
        }
        Class<AbstractMojo> clazz = AbstractMojo.class;
        synchronized (AbstractMojo.class) {
            MavenConfiguration configuration = this.getConfiguration();
            if (configuration.skip()) {
                this.getLog().info((CharSequence)"Skipping execution.");
            } else {
                AetherArtifactProvider artifactResolver = new AetherArtifactProvider(this.repositorySystem, this.repositorySystemSession, this.repositories);
                PluginRepository pluginRepository = this.pluginRepositoryProvider.getPluginRepository(configuration, (ArtifactProvider)artifactResolver);
                MojoExecutionContext mojoExecutionContext = new MojoExecutionContext(this.session, this.currentProject, this.execution, configuration, pluginRepository);
                MavenProject rootModule = mojoExecutionContext.getRootModule();
                Set<MavenProject> executedModules = this.getExecutedModules(rootModule);
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(pluginRepository.getClassLoader());
                try {
                    if (this.isResetStoreBeforeExecution(configuration) && executedModules.isEmpty()) {
                        this.withStore(store -> store.reset(), mojoExecutionContext);
                    }
                    this.execute(mojoExecutionContext, executedModules);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                }
                executedModules.add(this.currentProject);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected abstract void execute(MojoExecutionContext var1, Set<MavenProject> var2) throws MojoExecutionException, MojoFailureException;

    protected boolean isResetStoreBeforeExecution(MavenConfiguration configuration) {
        return false;
    }

    protected boolean isConnectorRequired() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void withStore(StoreOperation storeOperation, MojoExecutionContext mojoExecutionContext) throws MojoExecutionException, MojoFailureException {
        MavenProject rootModule = mojoExecutionContext.getRootModule();
        MavenConfiguration configuration = mojoExecutionContext.getConfiguration();
        Store store = this.getStore(mojoExecutionContext, () -> new File(rootModule.getBuild().getDirectory(), STORE_DIRECTORY));
        try {
            storeOperation.run(store);
        }
        finally {
            this.releaseStore(store, configuration.maven());
        }
    }

    private Set<MavenProject> getExecutedModules(MavenProject rootModule) {
        HashSet executedProjects;
        String executionKey = AbstractMojo.createExecutionKey(this.execution);
        String executedModulesContextKey = AbstractProjectMojo.class.getName() + "#executedModules";
        HashMap executedProjectsPerExecutionKey = (HashMap)rootModule.getContextValue(executedModulesContextKey);
        if (executedProjectsPerExecutionKey == null) {
            executedProjectsPerExecutionKey = new HashMap();
            rootModule.setContextValue(executedModulesContextKey, executedProjectsPerExecutionKey);
        }
        if ((executedProjects = (HashSet)executedProjectsPerExecutionKey.get(executionKey)) == null) {
            executedProjects = new HashSet();
            executedProjectsPerExecutionKey.put(executionKey, executedProjects);
        }
        return executedProjects;
    }

    private Store getStore(MojoExecutionContext mojoExecutionContext, Supplier<File> storeDirectorySupplier) throws MojoExecutionException {
        Store existingStore = this.cachingStoreProvider.getStore(mojoExecutionContext.getConfiguration().store(), storeDirectorySupplier, mojoExecutionContext.getPluginRepository(), (ArtifactProvider)new AetherArtifactProvider(this.repositorySystem, this.repositorySystemSession, this.repositories));
        if (!Store.class.isAssignableFrom(existingStore.getClass())) {
            throw new MojoExecutionException("Cannot re-use store instance from reactor. Either declare the plugin as extension or execute Maven using the property -Dreuse-store=false on the command line.");
        }
        return existingStore;
    }

    private void releaseStore(Store store, Maven maven) {
        if (!maven.reuseStore()) {
            this.cachingStoreProvider.closeStore(store);
        }
    }

    private MavenConfiguration getConfiguration() {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder("MojoConfigSource", 110);
        if (this.isConnectorRequired()) {
            configurationBuilder.with(Embedded.class, "connector-enabled", Boolean.valueOf(true));
        }
        MavenProjectConfigSource projectConfigSource = new MavenProjectConfigSource(this.currentProject);
        SettingsConfigSource settingsConfigSource = new SettingsConfigSource(this.session.getSettings());
        MavenPropertiesConfigSource projectPropertiesConfigSource = new MavenPropertiesConfigSource(this.currentProject.getProperties(), "Maven Project Properties");
        MavenPropertiesConfigSource userPropertiesConfigSource = new MavenPropertiesConfigSource(this.session.getUserProperties(), "Maven Session User Properties ");
        MavenPropertiesConfigSource systemPropertiesConfigSource = new MavenPropertiesConfigSource(this.session.getSystemProperties(), "Maven Session System Properties");
        ConfigSource[] configSources = new ConfigSource[]{configurationBuilder.build(), projectConfigSource, settingsConfigSource, projectPropertiesConfigSource, userPropertiesConfigSource, systemPropertiesConfigSource, this.getMavenPluginConfiguration()};
        File userHome = new File(System.getProperty("user.home"));
        return (MavenConfiguration)ConfigurationMappingLoader.builder(MavenConfiguration.class, this.configurationLocations).withUserHome(userHome).withWorkingDirectory(this.currentProject.getBasedir()).withDirectory(new File(this.session.getExecutionRootDirectory()), 90).withEnvVariables().withClasspath().load(configSources);
    }

    private ConfigSource getMavenPluginConfiguration() {
        return StringUtils.isNotEmpty((CharSequence)this.yaml) ? new YamlConfigSource("Maven plugin execution configuration", this.yaml, 100) : EmptyConfigSource.INSTANCE;
    }

    protected static interface StoreOperation {
        public void run(Store var1) throws MojoExecutionException, MojoFailureException;
    }
}

