/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.report.api.ReportTransformerException;
import com.buschmais.jqassistant.core.report.impl.HtmlReportTransformer;
import java.io.File;
import java.io.StringWriter;
import java.util.Locale;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;

@Mojo(name="report", defaultPhase=LifecyclePhase.SITE)
public class ReportMojo
extends AbstractMavenReport {
    @Parameter(property="jqassistant.report.xml")
    protected File xmlReportFile;

    public boolean canGenerateReport() {
        return this.getXmlReportFile().exists();
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        File reportFile = this.getXmlReportFile();
        StringWriter writer = new StringWriter();
        StreamSource xmlSource = new StreamSource(reportFile);
        StreamResult htmlTarget = new StreamResult(writer);
        this.getLog().info((CharSequence)("Transforming " + reportFile.getAbsolutePath() + "."));
        HtmlReportTransformer transformer = new HtmlReportTransformer();
        try {
            transformer.toEmbedded((Source)xmlSource, (Result)htmlTarget);
        }
        catch (ReportTransformerException e) {
            throw new MavenReportException("Cannot transform report '" + reportFile + "'.", (Exception)((Object)e));
        }
        this.getSink().rawText(writer.toString());
    }

    private File getXmlReportFile() {
        File selectedXmlReportFile = this.xmlReportFile != null ? this.xmlReportFile : new File(this.project.getBuild().getDirectory() + "/jqassistant/jqassistant-report.xml");
        return selectedXmlReportFile;
    }

    public String getDescription(Locale arg0) {
        return "The jQAssistant report.";
    }

    public String getName(Locale arg0) {
        return "jQAssistant";
    }

    public String getOutputName() {
        return "jqassistant";
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }
}

