/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.scm.maven.AbstractMojo;
import com.buschmais.jqassistant.scm.maven.MojoExecutionContext;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public abstract class AbstractProjectMojo
extends AbstractMojo {
    @Override
    public final void execute(MojoExecutionContext mojoExecutionContext, Set<MavenProject> executedModules) throws MojoExecutionException, MojoFailureException {
        boolean isLastModuleInProject = this.isLastModuleInProject(mojoExecutionContext, executedModules);
        if (isLastModuleInProject) {
            this.aggregate(mojoExecutionContext);
        }
    }

    private boolean isLastModuleInProject(MojoExecutionContext mojoExecutionContext, Set<MavenProject> executedModules) throws MojoExecutionException {
        Map<MavenProject, List<MavenProject>> projects = mojoExecutionContext.getProjects();
        MavenProject rootModule = mojoExecutionContext.getRootModule();
        List<MavenProject> projectModules = projects.get(rootModule);
        MavenProject currentModule = mojoExecutionContext.getCurrentModule();
        this.getLog().debug((CharSequence)("Verifying if '" + String.valueOf(currentModule) + "' is last module for project '" + String.valueOf(rootModule) + " (project modules='" + String.valueOf(projectModules) + "')."));
        HashSet<MavenProject> remainingModules = new HashSet<MavenProject>();
        MojoExecution mojoExecution = mojoExecutionContext.getMojoExecution();
        if (mojoExecution.getPlugin().getExecutions().isEmpty()) {
            this.getLog().debug((CharSequence)"No configured executions found, assuming CLI invocation.");
            remainingModules.addAll(projectModules);
        } else {
            for (MavenProject projectModule : projectModules) {
                if (!mojoExecutionContext.containsBuildPlugin(projectModule, mojoExecution.getPlugin())) continue;
                remainingModules.add(projectModule);
            }
        }
        remainingModules.removeAll(executedModules);
        remainingModules.remove(currentModule);
        if (remainingModules.isEmpty()) {
            this.getLog().debug((CharSequence)"Did not find any subsequent module with a plugin configuration, considering this module as the last one.");
            return true;
        }
        this.getLog().debug((CharSequence)("Found " + remainingModules.size() + " subsequent modules executing this plugin."));
        return false;
    }

    protected abstract void aggregate(MojoExecutionContext var1) throws MojoExecutionException, MojoFailureException;
}

