/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.RuleSet;
import com.buschmais.jqassistant.core.rule.api.source.FileRuleSource;
import com.buschmais.jqassistant.core.rule.api.source.RuleSource;
import com.buschmais.jqassistant.core.rule.impl.reader.RuleParser;
import com.buschmais.jqassistant.core.runtime.api.plugin.PluginRepository;
import com.buschmais.jqassistant.scm.maven.AbstractProjectMojo;
import com.buschmais.jqassistant.scm.maven.MojoExecutionContext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class AbstractRuleMojo
extends AbstractProjectMojo {
    protected final RuleSet readRules(MojoExecutionContext mojoExecutionContext) throws MojoExecutionException {
        Collection ruleParserPlugins;
        ArrayList<RuleSource> sources = new ArrayList<RuleSource>();
        PluginRepository pluginRepository = mojoExecutionContext.getPluginRepository();
        this.addRuleFiles(sources, mojoExecutionContext.getRuleDirectory());
        List ruleSources = pluginRepository.getRulePluginRepository().getRuleSources();
        sources.addAll(ruleSources);
        try {
            ruleParserPlugins = pluginRepository.getRulePluginRepository().getRuleParserPlugins(mojoExecutionContext.getConfiguration().analyze().rule());
        }
        catch (RuleException e) {
            throw new MojoExecutionException("Cannot get rules rule source reader plugins.", (Exception)((Object)e));
        }
        try {
            RuleParser ruleParser = new RuleParser(ruleParserPlugins);
            return ruleParser.parse(sources);
        }
        catch (RuleException e) {
            throw new MojoExecutionException("Cannot read rules.", (Exception)((Object)e));
        }
    }

    private void addRuleFiles(List<RuleSource> sources, File directory) throws MojoExecutionException {
        List<RuleSource> ruleSources = this.readRulesDirectory(directory);
        for (RuleSource ruleSource : ruleSources) {
            this.getLog().debug((CharSequence)("Adding rules from file " + String.valueOf(ruleSource)));
            sources.add(ruleSource);
        }
    }

    private List<RuleSource> readRulesDirectory(File rulesDirectory) throws MojoExecutionException {
        if (rulesDirectory.exists() && !rulesDirectory.isDirectory()) {
            throw new MojoExecutionException(rulesDirectory.getAbsolutePath() + " does not exist or is not a directory.");
        }
        try {
            return FileRuleSource.getRuleSources((File)rulesDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot read rule directory: " + rulesDirectory.getAbsolutePath(), (Exception)e);
        }
    }
}

