/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.neo4j.embedded.impl;

import com.buschmais.jqassistant.neo4j.embedded.EmbeddedNeo4jServer;
import com.buschmais.jqassistant.neo4j.embedded.EmbeddedNeo4jServerFactory;
import com.buschmais.jqassistant.neo4j.embedded.InstrumentationProvider;
import com.buschmais.jqassistant.neo4j.embedded.impl.Neo4jCommunityNeoServer;
import com.buschmais.xo.neo4j.embedded.api.EmbeddedNeo4jXOProvider;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.io.ByteUnit;

public class Neo4jCommunityServerFactory
implements EmbeddedNeo4jServerFactory {
    @Override
    public EmbeddedNeo4jServer getServer() {
        return new Neo4jCommunityNeoServer();
    }

    @Override
    public Properties getProperties(boolean connectorEnabled, String listenAddress, Integer boltPort, Optional<File> pluginDirectory) {
        EmbeddedNeo4jXOProvider.PropertiesBuilder propertiesBuilder = EmbeddedNeo4jXOProvider.propertiesBuilder().property(GraphDatabaseSettings.keep_logical_logs, (Object)Boolean.FALSE.toString()).property(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.mebiBytes((long)25L)).property(GraphDatabaseSettings.procedure_unrestricted, List.of("*")).property(GraphDatabaseInternalSettings.dump_diagnostics, (Object)false);
        pluginDirectory.ifPresent(dir -> {
            Neo4jCommunityServerFactory.prepareClassloader(dir.toPath());
            propertiesBuilder.property(GraphDatabaseSettings.plugin_dir, (Object)dir.toPath());
        });
        if (connectorEnabled) {
            propertiesBuilder.property(BoltConnector.enabled, (Object)true);
            propertiesBuilder.property(BoltConnector.listen_address, (Object)new SocketAddress(listenAddress, boltPort.intValue()));
        }
        return propertiesBuilder.build();
    }

    private static void prepareClassloader(Path pluginDir) {
        Consumer<Path> classpathAppender = Neo4jCommunityServerFactory.getClasspathAppender();
        try (Stream<Path> pathStream = Files.find(pluginDir, 1, (p, a) -> p.getFileName().toString().endsWith(".jar"), new FileVisitOption[0]);){
            pathStream.forEach(classpathAppender::accept);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot list plugin directory " + pluginDir, e);
        }
    }

    private static Consumer<Path> getClasspathAppender() {
        ClassLoader neo4jClassLoader = GraphDatabaseSettings.class.getClassLoader();
        if (neo4jClassLoader instanceof URLClassLoader) {
            return Neo4jCommunityServerFactory.getURLClassLoaderAppender(neo4jClassLoader);
        }
        return Neo4jCommunityServerFactory.getInstrumentationAppender();
    }

    private static Consumer<Path> getURLClassLoaderAppender(ClassLoader classLoader) {
        try {
            Method method = classLoader.getClass().getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            return path -> {
                try {
                    method.invoke((Object)classLoader, path.toUri().toURL());
                }
                catch (ReflectiveOperationException | MalformedURLException e) {
                    throw new IllegalStateException(e);
                }
            };
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Cannot use URLClassLoader to extend classpath.", e);
        }
    }

    private static Consumer<Path> getInstrumentationAppender() {
        return path -> InstrumentationProvider.INSTANCE.getInstrumentation().ifPresent(instrumentation -> {
            JarFile jarFile;
            try {
                jarFile = new JarFile(path.toFile());
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot create JAR from file " + path.toAbsolutePath(), e);
            }
            instrumentation.appendToSystemClassLoaderSearch(jarFile);
        });
    }
}

