/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.api.report;

import com.buschmais.jqassistant.core.report.api.SourceProvider;
import com.buschmais.jqassistant.core.report.api.model.Language;
import com.buschmais.jqassistant.core.report.api.model.LanguageElement;
import com.buschmais.jqassistant.core.report.api.model.source.FileLocation;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.ArtifactFileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.NamedDescriptor;
import com.buschmais.jqassistant.plugin.common.api.report.FileSourceHelper;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Optional;

@Language
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface Generic {
    public GenericLanguageElement value();

    public static enum GenericLanguageElement implements LanguageElement
    {
        Named{

            public SourceProvider<NamedDescriptor> getSourceProvider() {
                return new SourceProvider<NamedDescriptor>(){

                    public String getName(NamedDescriptor descriptor) {
                        return descriptor.getName();
                    }

                    public Optional<FileLocation> getSourceLocation(NamedDescriptor descriptor) {
                        if (descriptor instanceof FileDescriptor) {
                            return FileSourceHelper.getSourceLocation((FileDescriptor)((Object)descriptor), Optional.empty(), Optional.empty());
                        }
                        return Optional.empty();
                    }
                };
            }
        }
        ,
        File{

            public SourceProvider<? extends Descriptor> getSourceProvider() {
                return new SourceProvider<FileDescriptor>(){

                    public String getName(FileDescriptor descriptor) {
                        return descriptor.getFileName();
                    }

                    public Optional<FileLocation> getSourceLocation(FileDescriptor descriptor) {
                        return FileSourceHelper.getSourceLocation(descriptor, Optional.empty(), Optional.empty());
                    }
                };
            }
        }
        ,
        ArtifactFile{

            public SourceProvider<? extends Descriptor> getSourceProvider() {
                return new SourceProvider<ArtifactFileDescriptor>(){

                    public String getName(ArtifactFileDescriptor descriptor) {
                        return descriptor.getFullQualifiedName() != null ? descriptor.getFullQualifiedName() : descriptor.getFileName();
                    }

                    public Optional<FileLocation> getSourceLocation(ArtifactFileDescriptor descriptor) {
                        return FileSourceHelper.getSourceLocation(descriptor, Optional.empty(), Optional.empty());
                    }
                };
            }
        };


        public String getLanguage() {
            return "Generic";
        }
    }
}

