/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.api.scanner.filesystem;

import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVirtualFileResource
implements FileResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractVirtualFileResource.class);
    public static final String TMP_DIR_PREFIX = "jqassistant";
    private File directory;
    private File file;

    @Override
    public final File getFile() throws IOException {
        if (this.file == null) {
            this.directory = Files.createTempDirectory(TMP_DIR_PREFIX, new FileAttribute[0]).toFile();
            this.file = new File(this.directory, this.getRelativePath());
            File parentDirectory = this.file.getParentFile();
            if (!this.directory.equals(parentDirectory) && !parentDirectory.mkdirs()) {
                throw new IllegalStateException("Cannot create directory " + String.valueOf(parentDirectory));
            }
            try (InputStream input = this.createStream();
                 BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.file));){
                IOUtils.copy((InputStream)input, (OutputStream)output);
            }
        }
        return this.file;
    }

    protected abstract String getRelativePath() throws IOException;

    @Override
    public final void close() {
        if (this.directory != null) {
            try {
                FileUtils.deleteDirectory((File)this.directory);
            }
            catch (IOException e) {
                log.warn("Cannot delete file resource directory {}", (Object)this.directory, (Object)e);
            }
        }
    }
}

