/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.TarArchiveDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import java.io.IOException;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

@ScannerPlugin.Requires(value={FileDescriptor.class})
public class TarFileScannerPlugin
extends AbstractScannerPlugin<FileResource, TarArchiveDescriptor> {
    public boolean accepts(FileResource item, String path, Scope scope) throws IOException {
        return path.toLowerCase().endsWith(".tar");
    }

    public TarArchiveDescriptor scan(FileResource item, String path, Scope scope, Scanner scanner) throws IOException {
        return (TarArchiveDescriptor)scanner.scan((Object)new TarArchiveInputStream(item.createStream()), path, scope);
    }
}

