/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.impl.scanner.visitor;

import com.buschmais.jqassistant.plugin.java.api.model.MethodDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ParameterDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeCache;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.AbstractTypeSignatureVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.DependentTypeSignatureVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.VisitorHelper;
import org.objectweb.asm.signature.SignatureVisitor;

public class MethodSignatureVisitor
extends SignatureVisitor {
    private TypeCache.CachedType containingType;
    private MethodDescriptor methodDescriptor;
    private VisitorHelper visitorHelper;
    private DependentTypeSignatureVisitor dependentTypeSignatureVisitor;
    private int parameterIndex = 0;

    MethodSignatureVisitor(TypeCache.CachedType containingType, MethodDescriptor methodDescriptor, VisitorHelper visitorHelper, DependentTypeSignatureVisitor dependentTypeSignatureVisitor) {
        super(524288);
        this.containingType = containingType;
        this.methodDescriptor = methodDescriptor;
        this.visitorHelper = visitorHelper;
        this.dependentTypeSignatureVisitor = dependentTypeSignatureVisitor;
    }

    public SignatureVisitor visitClassBound() {
        return this.dependentTypeSignatureVisitor;
    }

    public SignatureVisitor visitInterfaceBound() {
        return this.dependentTypeSignatureVisitor;
    }

    public SignatureVisitor visitParameterType() {
        final ParameterDescriptor parameterDescriptor = this.visitorHelper.addParameterDescriptor(this.methodDescriptor, this.parameterIndex);
        ++this.parameterIndex;
        return new AbstractTypeSignatureVisitor(this.containingType, this.visitorHelper){

            public SignatureVisitor visitArrayType() {
                return MethodSignatureVisitor.this.dependentTypeSignatureVisitor;
            }

            public SignatureVisitor visitTypeArgument(char wildcard) {
                return MethodSignatureVisitor.this.dependentTypeSignatureVisitor;
            }

            @Override
            public void visitEnd(TypeDescriptor resolvedTypeDescriptor) {
                parameterDescriptor.setType(resolvedTypeDescriptor);
            }
        };
    }

    public SignatureVisitor visitReturnType() {
        return new AbstractTypeSignatureVisitor(this.containingType, this.visitorHelper){

            public SignatureVisitor visitArrayType() {
                return MethodSignatureVisitor.this.dependentTypeSignatureVisitor;
            }

            public SignatureVisitor visitTypeArgument(char wildcard) {
                return MethodSignatureVisitor.this.dependentTypeSignatureVisitor;
            }

            @Override
            public void visitEnd(TypeDescriptor resolvedTypeDescriptor) {
                MethodSignatureVisitor.this.methodDescriptor.setReturns(resolvedTypeDescriptor);
            }
        };
    }

    public SignatureVisitor visitExceptionType() {
        return this.dependentTypeSignatureVisitor;
    }
}

