/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.xml.api.scanner;

import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Predicate;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XMLFileFilter {
    private static XMLInputFactory factory;
    private static final Logger LOGGER;

    private XMLFileFilter() {
    }

    public static boolean rootElementMatches(FileResource fileResource, String path, String expectedRootElement) throws IOException {
        return XMLFileFilter.rootElementMatches(fileResource, path, (QName namespace) -> expectedRootElement.equals(namespace.getLocalPart()));
    }

    public static Boolean rootElementMatches(FileResource fileResource, String path, String expectedRootElement, String expectedNameSpace) throws IOException {
        return XMLFileFilter.rootElementMatches(fileResource, path, (QName rootElement) -> new QName(expectedNameSpace, expectedRootElement).equals(rootElement));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean rootElementMatches(FileResource fileResource, String path, Predicate<QName> rootElementPredicate) throws IOException {
        try (InputStream stream = fileResource.createStream();){
            XMLStreamReader reader = factory.createXMLStreamReader(stream);
            while (reader.hasNext()) {
                int event = reader.next();
                switch (event) {
                    case 1: {
                        boolean bl = rootElementPredicate.test(reader.getName());
                        return bl;
                    }
                }
            }
            return false;
        }
        catch (XMLStreamException e) {
            LOGGER.warn("Cannot parse XML file '{}'.", (Object)path);
        }
        return false;
    }

    static {
        LOGGER = LoggerFactory.getLogger(XMLFileFilter.class);
        factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.supportDTD", false);
    }
}

