/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.metadata.type.CompositeType;
import com.buschmais.xo.impl.proxy.InstanceInvocationHandler;
import com.buschmais.xo.spi.interceptor.InterceptorFactory;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;

public class ProxyFactory {
    private final InterceptorFactory interceptorFactory;
    private final ClassLoader classLoader;
    private final Cache<CompositeType, Constructor<?>> classCache = Caffeine.newBuilder().maximumSize(512L).build();

    public ProxyFactory(InterceptorFactory interceptorFactory, ClassLoader classLoader) {
        this.interceptorFactory = interceptorFactory;
        this.classLoader = classLoader;
    }

    public <Instance> Instance createInstance(InvocationHandler invocationHandler, CompositeType compositeType) {
        Object instance;
        Class[] classes = compositeType.getClasses();
        Constructor<?> constructor = (Constructor<?>)this.classCache.getIfPresent((Object)compositeType);
        if (constructor == null) {
            Class<?> type;
            try {
                type = Proxy.getProxyClass(this.classLoader, classes);
            }
            catch (IllegalArgumentException e) {
                throw new XOException("Cannot create proxy for " + compositeType + " of classes " + compositeType.getClasses(), (Throwable)e);
            }
            try {
                constructor = type.getConstructor(InvocationHandler.class);
            }
            catch (NoSuchMethodException e) {
                throw new XOException("Cannot find constructor for " + compositeType, (Throwable)e);
            }
            this.classCache.put((Object)compositeType, constructor);
        }
        try {
            instance = constructor.newInstance(invocationHandler);
        }
        catch (Exception e) {
            throw new XOException("Cannot create instance of  " + compositeType, (Throwable)e);
        }
        return (Instance)this.interceptorFactory.addInterceptor(instance, classes);
    }

    public <DatastoreType, Instance> InstanceInvocationHandler<DatastoreType> getInvocationHandler(Instance instance) {
        Object effectiveInstance = this.interceptorFactory.hasInterceptor(instance) ? this.interceptorFactory.removeInterceptor(instance) : instance;
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(effectiveInstance);
        if (!(invocationHandler instanceof InstanceInvocationHandler)) {
            throw new XOException("Instance " + instance + " implementing " + Arrays.asList(instance.getClass().getInterfaces()) + " is not a " + InstanceInvocationHandler.class.getName());
        }
        return (InstanceInvocationHandler)invocationHandler;
    }
}

