/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.XOTransaction;
import com.buschmais.xo.spi.datastore.DatastoreTransaction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public class XOTransactionImpl
implements XOTransaction {
    private final DatastoreTransaction datastoreTransaction;
    private final Collection<XOTransaction.Synchronization> defaultSynchronizations = new LinkedList<XOTransaction.Synchronization>();
    private final Collection<XOTransaction.Synchronization> synchronizations = new LinkedList<XOTransaction.Synchronization>();
    private boolean rollbackOnly;

    public XOTransactionImpl(DatastoreTransaction datastoreTransaction) {
        this.datastoreTransaction = datastoreTransaction;
    }

    public XOTransaction begin() {
        this.datastoreTransaction.begin();
        return this;
    }

    public void commit() {
        if (this.rollbackOnly) {
            throw new XOException("Transaction is marked as rollback only.");
        }
        this.beforeCompletion();
        boolean committed = false;
        try {
            this.datastoreTransaction.commit();
            committed = true;
        }
        finally {
            this.afterCompletion(committed);
        }
    }

    public void rollback() {
        try {
            this.datastoreTransaction.rollback();
        }
        finally {
            this.afterCompletion(false);
            this.rollbackOnly = false;
        }
    }

    public boolean isActive() {
        return this.datastoreTransaction.isActive();
    }

    public void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    public void registerSynchronization(XOTransaction.Synchronization synchronization) {
        this.synchronizations.add(synchronization);
    }

    public void unregisterSynchronization(XOTransaction.Synchronization synchronization) {
        this.synchronizations.remove(synchronization);
    }

    public void registerDefaultSynchronization(XOTransaction.Synchronization synchronization) {
        this.defaultSynchronizations.add(synchronization);
    }

    private void beforeCompletion() {
        this.executeSynchronizations(synchronization -> synchronization.beforeCompletion());
    }

    private void afterCompletion(boolean committed) {
        this.executeSynchronizations(synchronization -> synchronization.afterCompletion(committed));
        this.synchronizations.clear();
    }

    private void executeSynchronizations(SynchronizationOperation operation) {
        for (XOTransaction.Synchronization synchronization : this.defaultSynchronizations) {
            operation.run(synchronization);
        }
        for (XOTransaction.Synchronization synchronization : new ArrayList<XOTransaction.Synchronization>(this.synchronizations)) {
            operation.run(synchronization);
        }
    }

    public void close() {
        if (this.rollbackOnly) {
            this.rollback();
        } else {
            this.commit();
        }
    }

    private static interface SynchronizationOperation {
        public void run(XOTransaction.Synchronization var1);
    }
}

