/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.query;

import com.buschmais.xo.api.Query;
import com.buschmais.xo.api.ResultIterator;
import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.metadata.type.CompositeType;
import com.buschmais.xo.impl.AbstractResultIterable;
import com.buschmais.xo.impl.SessionContext;
import com.buschmais.xo.impl.proxy.query.RowInvocationHandler;
import com.buschmais.xo.impl.proxy.query.RowProxyMethodService;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;

class QueryResultIterableImpl<Entity, Relation, T>
extends AbstractResultIterable<T>
implements Query.Result<T> {
    private final SessionContext<?, Entity, ?, ?, ?, Relation, ?, ?, ?> sessionContext;
    private final ResultIterator<Map<String, Object>> iterator;
    private final SortedSet<Class<?>> returnTypes;
    private final RowProxyMethodService rowProxyMethodService;

    QueryResultIterableImpl(SessionContext<?, Entity, ?, ?, ?, Relation, ?, ?, ?> sessionContext, ResultIterator<Map<String, Object>> iterator, SortedSet<Class<?>> returnTypes) {
        this.sessionContext = sessionContext;
        this.iterator = iterator;
        this.returnTypes = returnTypes;
        this.rowProxyMethodService = returnTypes.isEmpty() || returnTypes.size() > 1 || sessionContext.getMetadataProvider().getQuery((AnnotatedElement)returnTypes.first()) != null ? new RowProxyMethodService(returnTypes) : null;
    }

    public ResultIterator<T> iterator() {
        return (ResultIterator)this.sessionContext.getInterceptorFactory().addInterceptor((Object)new ResultIterator<T>(){

            public boolean hasNext() {
                return QueryResultIterableImpl.this.iterator.hasNext();
            }

            public T next() {
                Map next = (Map)QueryResultIterableImpl.this.iterator.next();
                LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>(next.size(), 1.0f);
                for (Map.Entry entry : next.entrySet()) {
                    String column = (String)entry.getKey();
                    Object value = entry.getValue();
                    Object decodedValue = this.decodeValue(value);
                    row.put(column, decodedValue);
                }
                if (QueryResultIterableImpl.this.rowProxyMethodService != null) {
                    RowInvocationHandler invocationHandler = new RowInvocationHandler(row, QueryResultIterableImpl.this.rowProxyMethodService);
                    CompositeType compositeType = CompositeType.builder().type(Query.Result.CompositeRowObject.class).types(QueryResultIterableImpl.this.returnTypes).build();
                    return QueryResultIterableImpl.this.sessionContext.getProxyFactory().createInstance(invocationHandler, compositeType);
                }
                if (row.size() != 1) {
                    throw new XOException("Only single columns per row can be returned.");
                }
                return row.values().iterator().next();
            }

            public void remove() {
                QueryResultIterableImpl.this.iterator.remove();
            }

            private Object decodeValue(Object value) {
                if (value == null) {
                    return null;
                }
                if (QueryResultIterableImpl.this.sessionContext.getDatastoreSession().getDatastoreEntityManager().isEntity(value)) {
                    return QueryResultIterableImpl.this.sessionContext.getEntityInstanceManager().readInstance(value);
                }
                if (QueryResultIterableImpl.this.sessionContext.getDatastoreSession().getDatastoreRelationManager().isRelation(value)) {
                    return QueryResultIterableImpl.this.sessionContext.getRelationInstanceManager().readInstance(value);
                }
                Object decodedValue = value instanceof List ? this.decodeIterable((Iterable)value, new ArrayList<Object>()) : (value instanceof Set ? this.decodeIterable((Iterable)value, new HashSet<Object>()) : (value instanceof Map ? this.decodeMap((Map)value, new HashMap<Object, Object>()) : (value instanceof Iterable ? this.decodeIterable((Iterable)value, new ArrayList<Object>()) : value)));
                return decodedValue;
            }

            private Collection<Object> decodeIterable(Iterable<?> iterable, Collection<Object> decodedCollection) {
                for (Object o : iterable) {
                    decodedCollection.add(this.decodeValue(o));
                }
                return decodedCollection;
            }

            private Map<Object, Object> decodeMap(Map<?, ?> map, Map<Object, Object> decodedMap) {
                for (Map.Entry<?, ?> entry : map.entrySet()) {
                    decodedMap.put(this.decodeValue(entry.getKey()), this.decodeValue(entry.getValue()));
                }
                return decodedMap;
            }

            public void close() {
                QueryResultIterableImpl.this.iterator.close();
            }
        }, new Class[]{ResultIterator.class});
    }

    public void close() {
        this.iterator.close();
    }
}

