/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.spi;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Notification {
    Severity severity;
    String code;
    String title;
    String description;
    int offset;
    int line;
    int column;

    Notification(Severity severity, String code, String title, String description, int offset, int line, int column) {
        this.severity = severity;
        this.code = code;
        this.title = title;
        this.description = description;
        this.offset = offset;
        this.line = line;
        this.column = column;
    }

    public static NotificationBuilder builder() {
        return new NotificationBuilder();
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getCode() {
        return this.code;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String toString() {
        return "Notification(severity=" + this.getSeverity() + ", code=" + this.getCode() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", offset=" + this.getOffset() + ", line=" + this.getLine() + ", column=" + this.getColumn() + ")";
    }

    public static enum Severity {
        WARNING,
        INFORMATION;

        private static final Logger log;
        private static final Map<String, Severity> VALUES;

        public static Severity from(String name) {
            if (name == null) {
                return WARNING;
            }
            Severity severity = VALUES.get(name.toUpperCase());
            if (severity != null) {
                return severity;
            }
            log.warn("Unknown notification severity '{}', falling back to '{}'.", (Object)name, (Object)WARNING);
            return WARNING;
        }

        static {
            log = LoggerFactory.getLogger(Severity.class);
            VALUES = Arrays.stream(Severity.values()).collect(Collectors.toMap(value -> value.name().toUpperCase(), value -> value));
        }
    }

    public static class NotificationBuilder {
        private Severity severity;
        private String code;
        private String title;
        private String description;
        private int offset;
        private int line;
        private int column;

        NotificationBuilder() {
        }

        public NotificationBuilder severity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public NotificationBuilder code(String code) {
            this.code = code;
            return this;
        }

        public NotificationBuilder title(String title) {
            this.title = title;
            return this;
        }

        public NotificationBuilder description(String description) {
            this.description = description;
            return this;
        }

        public NotificationBuilder offset(int offset) {
            this.offset = offset;
            return this;
        }

        public NotificationBuilder line(int line) {
            this.line = line;
            return this;
        }

        public NotificationBuilder column(int column) {
            this.column = column;
            return this;
        }

        public Notification build() {
            return new Notification(this.severity, this.code, this.title, this.description, this.offset, this.line, this.column);
        }

        public String toString() {
            return "Notification.NotificationBuilder(severity=" + this.severity + ", code=" + this.code + ", title=" + this.title + ", description=" + this.description + ", offset=" + this.offset + ", line=" + this.line + ", column=" + this.column + ")";
        }
    }
}

