/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.spi.helper;

import com.buschmais.xo.neo4j.spi.helper.TypeConverter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Converter {
    private List<TypeConverter> converters;

    public Converter(List<TypeConverter> converters) {
        this.converters = converters;
    }

    public <T> T convert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> valueType = value.getClass();
        for (TypeConverter converter : this.converters) {
            if (!converter.getType().isAssignableFrom(valueType)) continue;
            return (T)converter.convert(value);
        }
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            ArrayList<T> values = new ArrayList<T>();
            for (Object o : iterable) {
                values.add(this.convert(o));
            }
            return (T)values;
        }
        if (value instanceof Map) {
            LinkedHashMap<T, T> result = new LinkedHashMap<T, T>();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                result.put(this.convert(entry.getKey()), this.convert(entry.getValue()));
            }
            return (T)result;
        }
        return (T)value;
    }
}

