/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.spi.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;

public class DependencyResolver<T> {
    private final Collection<T> elements;
    private final DependencyProvider<T> dependencyProvider;

    private DependencyResolver(Collection<T> elements, DependencyProvider<T> dependencyProvider) {
        this.elements = elements;
        this.dependencyProvider = dependencyProvider;
    }

    public static <T> DependencyResolver<T> newInstance(Collection<T> elements, DependencyProvider<T> dependencyProvider) {
        return new DependencyResolver<T>(elements, dependencyProvider);
    }

    public List<T> resolve() {
        LinkedHashSet resolved = new LinkedHashSet();
        LinkedHashSet path = new LinkedHashSet();
        LinkedList<LinkedList<T>> stack = new LinkedList<LinkedList<T>>();
        stack.push(new LinkedList<T>(this.elements));
        do {
            Queue currentElements;
            if (!(currentElements = (Queue)stack.peek()).isEmpty()) {
                Object currentElement = currentElements.peek();
                if (!resolved.contains(currentElement) && !path.contains(currentElement)) {
                    Set<T> dependencies = this.dependencyProvider.getDependencies(currentElement);
                    stack.push(new LinkedList<T>(dependencies));
                    path.add(currentElement);
                    continue;
                }
                currentElements.remove();
                continue;
            }
            stack.pop();
            if (stack.isEmpty()) continue;
            Object resolvedElement = ((Queue)stack.peek()).remove();
            path.remove(resolvedElement);
            resolved.add(resolvedElement);
        } while (!stack.isEmpty());
        return new ArrayList(resolved);
    }

    @FunctionalInterface
    public static interface DependencyProvider<T> {
        public Set<T> getDependencies(T var1);
    }
}

