/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.spi.interceptor;

import com.buschmais.xo.spi.interceptor.XOInterceptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class InvocationContext {
    private final Object instance;
    private final Method method;
    private final Object[] args;
    private final XOInterceptor[] chain;
    private int index = 0;

    public InvocationContext(Object instance, Method method, Object[] args, XOInterceptor[] chain) {
        this.instance = instance;
        this.method = method;
        this.args = args;
        this.chain = chain;
    }

    public Object proceed() throws Throwable {
        if (this.index < this.chain.length) {
            XOInterceptor xoInterceptor = this.chain[this.index];
            ++this.index;
            return xoInterceptor.invoke(this);
        }
        try {
            return this.method.invoke(this.instance, this.args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getArguments() {
        return this.args;
    }

    public Object getInstance() {
        return this.instance;
    }
}

