/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.spi.interceptor;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.spi.interceptor.InterceptorInvocationHandler;
import com.buschmais.xo.spi.interceptor.XOInterceptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class InterceptorFactory {
    private final XOInterceptor[] chain;

    public InterceptorFactory(List<? extends XOInterceptor> chain) {
        ArrayList<XOInterceptor> effectiveChain = new ArrayList<XOInterceptor>(chain.size());
        for (XOInterceptor xOInterceptor : chain) {
            if (!xOInterceptor.isActive()) continue;
            effectiveChain.add(xOInterceptor);
        }
        this.chain = effectiveChain.toArray(new XOInterceptor[effectiveChain.size()]);
    }

    public <T> T addInterceptor(T instance, Class<?> ... interfaces) {
        if (this.chain.length == 0) {
            return instance;
        }
        InterceptorInvocationHandler invocationHandler = new InterceptorInvocationHandler(instance, this.chain);
        return (T)Proxy.newProxyInstance(instance.getClass().getClassLoader(), interfaces, (InvocationHandler)invocationHandler);
    }

    public <T> boolean hasInterceptor(T instance) {
        return Proxy.isProxyClass(instance.getClass()) && Proxy.getInvocationHandler(instance) instanceof InterceptorInvocationHandler;
    }

    public <T> T removeInterceptor(T instance) {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(instance);
        if (!InterceptorInvocationHandler.class.isAssignableFrom(invocationHandler.getClass())) {
            throw new XOException(String.valueOf(invocationHandler) + " implementing " + String.valueOf(Arrays.asList(invocationHandler.getClass().getInterfaces())) + " is not of expected type " + InterceptorInvocationHandler.class.getName());
        }
        return (T)((InterceptorInvocationHandler)invocationHandler).getInstance();
    }
}

