/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.annotations.keycloak;

import com.c4_soft.springaddons.security.oauth2.test.annotations.StringClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.keycloak.IDTokenBuilderHelper;
import com.c4_soft.springaddons.security.oauth2.test.annotations.keycloak.KeycloakPermission;
import com.c4_soft.springaddons.security.oauth2.test.annotations.keycloak.KeycloakResourceAccess;
import com.c4_soft.springaddons.security.oauth2.test.annotations.keycloak.WithMockKeycloakAuth;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.idm.authorization.Permission;
import org.springframework.util.StringUtils;

class AccessTokenBuilderHelper {
    AccessTokenBuilderHelper() {
    }

    public static AccessToken feed(AccessToken token, WithMockKeycloakAuth annotation) {
        IDTokenBuilderHelper.feed((IDToken)token, annotation.claims());
        token.setAuthorization(AccessTokenBuilderHelper.authorization(annotation.accessToken().authorization().permissions()));
        token.setRealmAccess(AccessTokenBuilderHelper.access(Stream.concat(Stream.of(annotation.accessToken().realmAccess().roles()), Stream.of(annotation.authorities())), annotation.accessToken().realmAccess().verifyCaller()));
        if (StringUtils.hasLength((String)annotation.accessToken().certConf().certThumbprint())) {
            AccessToken.CertConf certConf = new AccessToken.CertConf();
            certConf.setCertThumbprint(annotation.accessToken().certConf().certThumbprint());
            token.setCertConf(certConf);
        }
        token.setResourceAccess(AccessTokenBuilderHelper.resourceAccess(annotation.accessToken().resourceAccess()));
        token.setAllowedOrigins(Stream.of(annotation.accessToken().allowedOrigins()).collect(Collectors.toSet()));
        token.setTrustedCertificates(Stream.of(annotation.accessToken().trustedCertificates()).collect(Collectors.toSet()));
        return token;
    }

    static AccessToken.Authorization authorization(KeycloakPermission ... permissions) {
        AccessToken.Authorization authorization = new AccessToken.Authorization();
        authorization.setPermissions((Collection)Stream.of(permissions).map(AccessTokenBuilderHelper::permission).collect(Collectors.toList()));
        return authorization;
    }

    static Permission permission(KeycloakPermission annotation) {
        Set scopes = Stream.of(annotation.scopes()).collect(Collectors.toSet());
        HashMap claims = new HashMap(annotation.claims().length);
        for (StringClaim claim : annotation.claims()) {
            HashSet<String> c = claims.containsKey(claim.name()) ? (Set)claims.get(claim.name()) : new HashSet<String>();
            c.add(claim.value());
            claims.put(claim.name(), c);
        }
        return new Permission(annotation.rsid(), AccessTokenBuilderHelper.nullIfEmpty(annotation.rsname()), scopes, claims);
    }

    static AccessToken.Access access(Stream<String> roles, Boolean verifyCaller) {
        AccessToken.Access access = new AccessToken.Access();
        access.roles(roles.collect(Collectors.toSet()));
        access.verifyCaller(verifyCaller);
        return access;
    }

    static Map<String, AccessToken.Access> resourceAccess(KeycloakResourceAccess[] annotations) {
        HashMap<String, AccessToken.Access> accesses = new HashMap<String, AccessToken.Access>(annotations.length);
        for (KeycloakResourceAccess annotation : annotations) {
            accesses.put(annotation.resourceId(), AccessTokenBuilderHelper.access(Stream.of(annotation.access().roles()), annotation.access().verifyCaller()));
        }
        return accesses;
    }

    private static String nullIfEmpty(String str) {
        return StringUtils.hasText((String)str) ? str : null;
    }
}

