/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.KTypeCollection;
import com.carrotsearch.hppc.KTypeLookupContainer;
import com.carrotsearch.hppc.cursors.KTypeCursor;
import com.carrotsearch.hppc.predicates.KTypePredicate;
import java.lang.reflect.Array;
import java.util.Arrays;

abstract class AbstractKTypeCollection<KType>
implements KTypeCollection<KType> {
    AbstractKTypeCollection() {
    }

    @Override
    public int removeAll(KTypeLookupContainer<? extends KType> c) {
        final KTypeLookupContainer<? extends KType> c2 = c;
        return this.removeAll(new KTypePredicate<KType>(){

            @Override
            public boolean apply(KType k) {
                return c2.contains(k);
            }
        });
    }

    @Override
    public int retainAll(KTypeLookupContainer<? extends KType> c) {
        final KTypeLookupContainer<? extends KType> c2 = c;
        return this.removeAll(new KTypePredicate<KType>(){

            @Override
            public boolean apply(KType k) {
                return !c2.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final KTypePredicate<? super KType> predicate) {
        return this.removeAll(new KTypePredicate<KType>(){

            @Override
            public boolean apply(KType value) {
                return !predicate.apply(value);
            }
        });
    }

    @Override
    public KType[] toArray(Class<? super KType> clazz) {
        int size = this.size();
        Object[] array = (Object[])Array.newInstance(clazz, size);
        int i = 0;
        for (KTypeCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        int i = 0;
        for (KTypeCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

