/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.jira.api;

import com.chutneytesting.jira.api.JiraConfigurationDto;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="JiraConfigurationDto", generator="Immutables")
@Immutable
public final class ImmutableJiraConfigurationDto
implements JiraConfigurationDto {
    private final String url;
    private final String username;
    private final String password;
    @Nullable
    private final String urlProxy;
    @Nullable
    private final String userProxy;
    @Nullable
    private final String passwordProxy;

    private ImmutableJiraConfigurationDto(String url, String username, String password, @Nullable String urlProxy, @Nullable String userProxy, @Nullable String passwordProxy) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.urlProxy = urlProxy;
        this.userProxy = userProxy;
        this.passwordProxy = passwordProxy;
    }

    @Override
    @JsonProperty(value="url")
    public String url() {
        return this.url;
    }

    @Override
    @JsonProperty(value="username")
    public String username() {
        return this.username;
    }

    @Override
    @JsonProperty(value="password")
    public String password() {
        return this.password;
    }

    @Override
    @JsonProperty(value="urlProxy")
    public Optional<String> urlProxy() {
        return Optional.ofNullable(this.urlProxy);
    }

    @Override
    @JsonProperty(value="userProxy")
    public Optional<String> userProxy() {
        return Optional.ofNullable(this.userProxy);
    }

    @Override
    @JsonProperty(value="passwordProxy")
    public Optional<String> passwordProxy() {
        return Optional.ofNullable(this.passwordProxy);
    }

    public final ImmutableJiraConfigurationDto withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutableJiraConfigurationDto(newValue, this.username, this.password, this.urlProxy, this.userProxy, this.passwordProxy);
    }

    public final ImmutableJiraConfigurationDto withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return new ImmutableJiraConfigurationDto(this.url, newValue, this.password, this.urlProxy, this.userProxy, this.passwordProxy);
    }

    public final ImmutableJiraConfigurationDto withPassword(String value) {
        String newValue = Objects.requireNonNull(value, "password");
        if (this.password.equals(newValue)) {
            return this;
        }
        return new ImmutableJiraConfigurationDto(this.url, this.username, newValue, this.urlProxy, this.userProxy, this.passwordProxy);
    }

    public final ImmutableJiraConfigurationDto withUrlProxy(String value) {
        String newValue = Objects.requireNonNull(value, "urlProxy");
        if (Objects.equals(this.urlProxy, newValue)) {
            return this;
        }
        return new ImmutableJiraConfigurationDto(this.url, this.username, this.password, newValue, this.userProxy, this.passwordProxy);
    }

    public final ImmutableJiraConfigurationDto withUrlProxy(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.urlProxy, value)) {
            return this;
        }
        return new ImmutableJiraConfigurationDto(this.url, this.username, this.password, value, this.userProxy, this.passwordProxy);
    }

    public final ImmutableJiraConfigurationDto withUserProxy(String value) {
        String newValue = Objects.requireNonNull(value, "userProxy");
        if (Objects.equals(this.userProxy, newValue)) {
            return this;
        }
        return new ImmutableJiraConfigurationDto(this.url, this.username, this.password, this.urlProxy, newValue, this.passwordProxy);
    }

    public final ImmutableJiraConfigurationDto withUserProxy(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.userProxy, value)) {
            return this;
        }
        return new ImmutableJiraConfigurationDto(this.url, this.username, this.password, this.urlProxy, value, this.passwordProxy);
    }

    public final ImmutableJiraConfigurationDto withPasswordProxy(String value) {
        String newValue = Objects.requireNonNull(value, "passwordProxy");
        if (Objects.equals(this.passwordProxy, newValue)) {
            return this;
        }
        return new ImmutableJiraConfigurationDto(this.url, this.username, this.password, this.urlProxy, this.userProxy, newValue);
    }

    public final ImmutableJiraConfigurationDto withPasswordProxy(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.passwordProxy, value)) {
            return this;
        }
        return new ImmutableJiraConfigurationDto(this.url, this.username, this.password, this.urlProxy, this.userProxy, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJiraConfigurationDto && this.equalTo(0, (ImmutableJiraConfigurationDto)another);
    }

    private boolean equalTo(int synthetic, ImmutableJiraConfigurationDto another) {
        return this.url.equals(another.url) && this.username.equals(another.username) && this.password.equals(another.password) && Objects.equals(this.urlProxy, another.urlProxy) && Objects.equals(this.userProxy, another.userProxy) && Objects.equals(this.passwordProxy, another.passwordProxy);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + this.password.hashCode();
        h += (h << 5) + Objects.hashCode(this.urlProxy);
        h += (h << 5) + Objects.hashCode(this.userProxy);
        h += (h << 5) + Objects.hashCode(this.passwordProxy);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("JiraConfigurationDto{");
        builder.append("url=").append(this.url);
        builder.append(", ");
        builder.append("username=").append(this.username);
        builder.append(", ");
        builder.append("password=").append(this.password);
        if (this.urlProxy != null) {
            builder.append(", ");
            builder.append("urlProxy=").append(this.urlProxy);
        }
        if (this.userProxy != null) {
            builder.append(", ");
            builder.append("userProxy=").append(this.userProxy);
        }
        if (this.passwordProxy != null) {
            builder.append(", ");
            builder.append("passwordProxy=").append(this.passwordProxy);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableJiraConfigurationDto fromJson(Json json) {
        Builder builder = ImmutableJiraConfigurationDto.builder();
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.username != null) {
            builder.username(json.username);
        }
        if (json.password != null) {
            builder.password(json.password);
        }
        if (json.urlProxy != null) {
            builder.urlProxy(json.urlProxy);
        }
        if (json.userProxy != null) {
            builder.userProxy(json.userProxy);
        }
        if (json.passwordProxy != null) {
            builder.passwordProxy(json.passwordProxy);
        }
        return builder.build();
    }

    public static ImmutableJiraConfigurationDto copyOf(JiraConfigurationDto instance) {
        if (instance instanceof ImmutableJiraConfigurationDto) {
            return (ImmutableJiraConfigurationDto)instance;
        }
        return ImmutableJiraConfigurationDto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="JiraConfigurationDto", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_URL = 1L;
        private static final long INIT_BIT_USERNAME = 2L;
        private static final long INIT_BIT_PASSWORD = 4L;
        private long initBits = 7L;
        @Nullable
        private String url;
        @Nullable
        private String username;
        @Nullable
        private String password;
        @Nullable
        private String urlProxy;
        @Nullable
        private String userProxy;
        @Nullable
        private String passwordProxy;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(JiraConfigurationDto instance) {
            Optional<String> passwordProxyOptional;
            Optional<String> userProxyOptional;
            Objects.requireNonNull(instance, "instance");
            this.url(instance.url());
            this.username(instance.username());
            this.password(instance.password());
            Optional<String> urlProxyOptional = instance.urlProxy();
            if (urlProxyOptional.isPresent()) {
                this.urlProxy(urlProxyOptional);
            }
            if ((userProxyOptional = instance.userProxy()).isPresent()) {
                this.userProxy(userProxyOptional);
            }
            if ((passwordProxyOptional = instance.passwordProxy()).isPresent()) {
                this.passwordProxy(passwordProxyOptional);
            }
            return this;
        }

        @JsonProperty(value="url")
        @CanIgnoreReturnValue
        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="username")
        @CanIgnoreReturnValue
        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="password")
        @CanIgnoreReturnValue
        public final Builder password(String password) {
            this.password = Objects.requireNonNull(password, "password");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder urlProxy(String urlProxy) {
            this.urlProxy = Objects.requireNonNull(urlProxy, "urlProxy");
            return this;
        }

        @JsonProperty(value="urlProxy")
        @CanIgnoreReturnValue
        public final Builder urlProxy(Optional<String> urlProxy) {
            this.urlProxy = urlProxy.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder userProxy(String userProxy) {
            this.userProxy = Objects.requireNonNull(userProxy, "userProxy");
            return this;
        }

        @JsonProperty(value="userProxy")
        @CanIgnoreReturnValue
        public final Builder userProxy(Optional<String> userProxy) {
            this.userProxy = userProxy.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder passwordProxy(String passwordProxy) {
            this.passwordProxy = Objects.requireNonNull(passwordProxy, "passwordProxy");
            return this;
        }

        @JsonProperty(value="passwordProxy")
        @CanIgnoreReturnValue
        public final Builder passwordProxy(Optional<String> passwordProxy) {
            this.passwordProxy = passwordProxy.orElse(null);
            return this;
        }

        public ImmutableJiraConfigurationDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJiraConfigurationDto(this.url, this.username, this.password, this.urlProxy, this.userProxy, this.passwordProxy);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("url");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("username");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("password");
            }
            return "Cannot build JiraConfigurationDto, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="JiraConfigurationDto", generator="Immutables")
    static final class Json
    implements JiraConfigurationDto {
        @Nullable
        String url;
        @Nullable
        String username;
        @Nullable
        String password;
        @Nullable
        Optional<String> urlProxy = Optional.empty();
        @Nullable
        Optional<String> userProxy = Optional.empty();
        @Nullable
        Optional<String> passwordProxy = Optional.empty();

        Json() {
        }

        @JsonProperty(value="url")
        public void setUrl(String url) {
            this.url = url;
        }

        @JsonProperty(value="username")
        public void setUsername(String username) {
            this.username = username;
        }

        @JsonProperty(value="password")
        public void setPassword(String password) {
            this.password = password;
        }

        @JsonProperty(value="urlProxy")
        public void setUrlProxy(Optional<String> urlProxy) {
            this.urlProxy = urlProxy;
        }

        @JsonProperty(value="userProxy")
        public void setUserProxy(Optional<String> userProxy) {
            this.userProxy = userProxy;
        }

        @JsonProperty(value="passwordProxy")
        public void setPasswordProxy(Optional<String> passwordProxy) {
            this.passwordProxy = passwordProxy;
        }

        @Override
        public String url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String username() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String password() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> urlProxy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> userProxy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> passwordProxy() {
            throw new UnsupportedOperationException();
        }
    }
}

